/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.events.event.PlayerAteSoupEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.BoolArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.BukkitUtils;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@BetaKit
public class RandomKit
extends AbstractKit {
    public static final RandomKit INSTANCE = new RandomKit();
    private static final String QUESTION_MARK_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWU1YmI4YjMxZjQ2YWE5YWYxYmFhODhiNzRmMGZmMzgzNTE4Y2QyM2ZhYWM1MmEzYWNiOTZjZmU5MWUyMmViYyJ9fX0";
    @IntArg
    private final int randomItemAfterXSoups;
    @IntArg
    private final int itemAmount;
    @BoolArg
    private final boolean withPresoup;
    private final String soupAmountKey = "soupAmount" + this.getName();

    private RandomKit() {
        super("Random");
        this.randomItemAfterXSoups = 10;
        this.itemAmount = 1;
        this.withPresoup = false;
        this.setDisplayItem(new KitItemBuilder(Material.PLAYER_HEAD).setPlayerSkullSkin(QUESTION_MARK_HEAD).build());
    }

    @Override
    @KitEvent
    public void onPlayerAteSoupEvent(PlayerAteSoupEvent event, KitPlayer kitPlayer) {
        boolean hasPresouped = event.hasPresouped();
        if (this.withPresoup) {
            this.handleEatingSoup(kitPlayer);
        } else if (!hasPresouped) {
            this.handleEatingSoup(kitPlayer);
        }
    }

    private void handleEatingSoup(KitPlayer kitPlayer) {
        AtomicInteger soupAmount = kitPlayer.getKitAttributeOrDefault(this.soupAmountKey, new AtomicInteger());
        soupAmount.incrementAndGet();
        kitPlayer.putKitAttribute(this.soupAmountKey, soupAmount);
        if (soupAmount.get() >= this.randomItemAfterXSoups) {
            ItemStack itemStack = new ItemStack(BukkitUtils.getRandomMaterial(), this.itemAmount);
            KitApi.getInstance().giveKitItemsIfInvFull(kitPlayer, this, Collections.singletonList(itemStack));
            kitPlayer.putKitAttribute(this.soupAmountKey, new AtomicInteger());
        }
    }
}

