/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.kits.SpitKit;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.pvp.SoupHealing;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PerfectKit
extends AbstractKit
implements Listener {
    public static final PerfectKit INSTANCE = new PerfectKit();
    private final String soupAmountKey = this.getName() + "soupAmount";
    @IntArg
    private final int soupAmountForReward;

    private PerfectKit() {
        super("Perfect", Material.BEACON);
        this.soupAmountForReward = 7;
    }

    @EventHandler
    public void onSoupEat(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!kitPlayer.hasKit(this)) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR) {
            return;
        }
        if (event.getItem() == null) {
            return;
        }
        if (event.hasItem() && SoupHealing.SOUP_MATERIAL.contains(event.getMaterial())) {
            boolean presouped;
            if (event.getHand() == EquipmentSlot.OFF_HAND) {
                return;
            }
            int heal = 7;
            if (event.getItem().getType() == Material.SUSPICIOUS_STEW) {
                heal = SpitKit.INSTANCE.getSpitSoupHealing();
            }
            boolean bl = presouped = player.getHealth() + (double)heal > player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue();
            if (!presouped) {
                this.incrementStreak(kitPlayer);
                int soupAmount = kitPlayer.getKitAttributeOrDefault(this.soupAmountKey, 0);
                if (soupAmount % this.soupAmountForReward == 0) {
                    int soupsToBeAdded = (int)Math.round(Math.sqrt((double)(soupAmount / this.soupAmountForReward) * 1.3));
                    for (int i = 0; i < soupsToBeAdded; ++i) {
                        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MUSHROOM_STEW)});
                    }
                    player.sendMessage(Localization.INSTANCE.getMessage("perfect.streak", ChatUtils.locale((Player)player)));
                }
            } else if (kitPlayer.isInCombat()) {
                this.resetStreak(kitPlayer);
            }
        }
    }

    private void incrementStreak(KitPlayer kitPlayer) {
        Player player = kitPlayer.getBukkitPlayer().get();
        int soupAmount = kitPlayer.getKitAttributeOrDefault(this.soupAmountKey, 0);
        kitPlayer.putKitAttribute(this.soupAmountKey, soupAmount + 1);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 100.0f, 1.0f);
    }

    private void resetStreak(KitPlayer kitPlayer) {
        Player player = kitPlayer.getBukkitPlayer().get();
        if (kitPlayer.getKitAttributeOrDefault(this.soupAmountKey, 0) > 0) {
            player.playSound(player.getLocation(), Sound.ENTITY_DONKEY_DEATH, 1.0f, 1.0f);
        }
        kitPlayer.putKitAttribute(this.soupAmountKey, 0);
    }
}

