/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.events.KitEventHandler;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PenguinKit
extends AbstractKit
implements Listener {
    public static final PenguinKit INSTANCE = new PenguinKit();
    private final String snowballKey;
    @FloatArg(min=0.0f)
    private final float cooldown;

    protected PenguinKit() {
        super("Penguin", Material.ICE);
        this.cooldown = 15.0f;
        this.snowballKey = "penguinSnowball";
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onProjectileHitEvent(ProjectileHitEvent event, KitPlayer kitPlayer, Entity hitEntity) {
        if (kitPlayer.isValid() && event.getEntity().getScoreboardTags().contains(this.snowballKey) && hitEntity != null) {
            for (int i = -1; i < 2; ++i) {
                hitEntity.getLocation().clone().add((double)i, 0.0, 0.0).getBlock().setType(Material.ICE);
                hitEntity.getLocation().clone().add(0.0, (double)i, 0.0).getBlock().setType(Material.ICE);
                hitEntity.getLocation().clone().add(0.0, 0.0, (double)i).getBlock().setType(Material.ICE);
            }
            hitEntity.getWorld().playSound(hitEntity.getLocation(), Sound.BLOCK_SNOW_BREAK, 1.0f, 1.0f);
        }
    }

    @KitEvent(ignoreCooldown=true)
    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (event.getAction() != Action.LEFT_CLICK_AIR) {
            return;
        }
        if (!KitEventHandler.canUseKit((Event)event, kitPlayer, this)) {
            return;
        }
        if (!player.isGliding()) {
            return;
        }
        Snowball snowball = (Snowball)player.launchProjectile(Snowball.class, player.getLocation().getDirection().multiply(2));
        snowball.addScoreboardTag(this.snowballKey);
    }

    @Override
    @KitEvent
    public void onPlayerMoveEvent(PlayerMoveEvent event, final KitPlayer kitPlayer) {
        final Player player = event.getPlayer();
        if (player.getFallDistance() > 2.0f && player.isSneaking()) {
            player.setGliding(true);
            player.setVelocity(player.getLocation().getDirection().multiply(kitPlayer.isInCombat() ? 1.2 : 2.0));
            kitPlayer.activateKitCooldown(this);
            new BukkitRunnable(){

                public void run() {
                    if (!kitPlayer.isValid() || !player.isOnline()) {
                        this.cancel();
                    } else if (player.isGliding()) {
                        Location location = player.getLocation().clone().subtract(0.0, 2.0, 0.0);
                        Material old = location.getBlock().getType();
                        location.getBlock().setType(Material.ICE);
                        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> location.getBlock().setType(old), 40L);
                    }
                }
            }.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 1L);
        }
    }

    @KitEvent(ignoreCooldown=true)
    @EventHandler
    public void onEntityToggleGlideEvent(EntityToggleGlideEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player entity = (Player)event.getEntity();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(entity);
        if (!KitEventHandler.canUseKit((Event)event, kitPlayer, this)) {
            return;
        }
        ItemStack chestplate = entity.getInventory().getChestplate();
        if (chestplate != null && chestplate.getType().equals((Object)Material.ELYTRA)) {
            return;
        }
        if (!event.getEntity().isOnGround()) {
            event.setCancelled(true);
        }
    }
}

