/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.pathfinder.LaborPathfinderMoveToLocation;
import de.hglabor.utils.noriskutils.pvpbots.PvPBot;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.monster.EntityZombie;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftZombie;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MagicianKit
extends AbstractKit {
    public static final MagicianKit INSTANCE = new MagicianKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private int durationInSeconds;
    @IntArg
    private int validColorRgb;
    @IntArg
    private int invalidColorRgb;

    protected MagicianKit() {
        super("Magician", Material.DRAGON_BREATH);
        this.setMainKitItem(this.getDisplayMaterial());
        this.cooldown = 35.0f;
        this.durationInSeconds = 6;
        this.validColorRgb = 11585581;
        this.invalidColorRgb = 2547655;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        new MagicianClone(true, kitPlayer, MagicianDirection.POSITIVE_X, this.validColorRgb, this.invalidColorRgb).spawn(this.durationInSeconds);
        new MagicianClone(false, kitPlayer, MagicianDirection.NEGATIVE_X, this.validColorRgb, this.invalidColorRgb).spawn(this.durationInSeconds);
        new MagicianClone(false, kitPlayer, MagicianDirection.POSITIVE_Z, this.validColorRgb, this.invalidColorRgb).spawn(this.durationInSeconds);
        new MagicianClone(false, kitPlayer, MagicianDirection.NEGATIVE_Z, this.validColorRgb, this.invalidColorRgb).spawn(this.durationInSeconds);
        kitPlayer.activateKitCooldown(this);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    public static class MagicianClone {
        protected final boolean isValid;
        protected final KitPlayer kitPlayer;
        protected final MagicianDirection magicianDirection;
        protected final int validColorRgb;
        protected final int invalidColorRgb;

        public MagicianClone(boolean isValid, KitPlayer kitPlayer, MagicianDirection magicianDirection, int validColorRgb, int invalidColorRgb) {
            this.isValid = isValid;
            this.kitPlayer = kitPlayer;
            this.magicianDirection = magicianDirection;
            this.validColorRgb = validColorRgb;
            this.invalidColorRgb = invalidColorRgb;
        }

        public void spawn(final int durationTime) {
            Optional<Player> optionalPlayer = this.kitPlayer.getBukkitPlayer();
            if (optionalPlayer.isPresent()) {
                final Player player = optionalPlayer.get();
                final PvPBot pvpBot = new PvPBot(player.getWorld(), player.getName(), player, KitApi.getInstance().getPlugin());
                pvpBot.withHealth(120);
                pvpBot.withMovementSpeed(0.17);
                pvpBot.spawn(player.getLocation().clone().add(0.0, 1.0, 0.0));
                final Zombie zombie = pvpBot.getEntity();
                EntityInsentient craftMonster = (EntityInsentient)((CraftEntity)zombie).getHandle();
                this.clearPathfinders(((CraftZombie)zombie).getHandle());
                zombie.setTarget(null);
                Location location = player.getLocation().clone();
                switch (this.magicianDirection) {
                    case POSITIVE_X: {
                        location.add(15.0, 1.0, 0.0);
                        break;
                    }
                    case NEGATIVE_X: {
                        location.add(-15.0, 1.0, 0.0);
                        break;
                    }
                    case POSITIVE_Z: {
                        location.add(0.0, 1.0, 15.0);
                        break;
                    }
                    case NEGATIVE_Z: {
                        location.add(0.0, 1.0, -15.0);
                    }
                }
                craftMonster.bR.a(0, (PathfinderGoal)new LaborPathfinderMoveToLocation(location, craftMonster));
                craftMonster.bR.a(1, (PathfinderGoal)new PathfinderGoalFloat(craftMonster));
                final long activationTime = System.currentTimeMillis();
                new BukkitRunnable(){

                    public void run() {
                        if ((double)System.currentTimeMillis() >= (double)activationTime + (double)durationTime * 1000.0 || !kitPlayer.isValid()) {
                            pvpBot.die(DamageSource.t);
                            this.cancel();
                            for (Player p : Bukkit.getOnlinePlayers().stream().filter(it -> it != player).toList()) {
                                p.showPlayer((Plugin)KitApi.getInstance().getPlugin(), player);
                            }
                        } else {
                            if (isValid) {
                                for (Player p : Bukkit.getOnlinePlayers().stream().filter(it -> it != player).toList()) {
                                    p.hidePlayer((Plugin)KitApi.getInstance().getPlugin(), player);
                                }
                                if (!zombie.getPassengers().contains(player)) {
                                    zombie.addPassenger((Entity)player);
                                }
                            }
                            zombie.getWorld().spawnParticle(Particle.REDSTONE, zombie.getLocation().clone().add(0.0, 0.5, 0.0), 0, (Object)new Particle.DustOptions(Color.fromBGR((int)(isValid ? validColorRgb : invalidColorRgb)), 1.5f));
                        }
                    }
                }.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 1L, 1L);
            }
        }

        private void clearPathfinders(EntityZombie entity) {
            entity.bR = new PathfinderGoalSelector(entity.t.ac());
            entity.bS = new PathfinderGoalSelector(entity.t.ac());
        }
    }

    public static enum MagicianDirection {
        POSITIVE_X,
        NEGATIVE_X,
        POSITIVE_Z,
        NEGATIVE_Z;

    }
}

