/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.BlockBreakEvent;

public class LumberjackKit
extends AbstractKit {
    public static final LumberjackKit INSTANCE = new LumberjackKit();
    private final String logCounterKey = this.getName() + "logCounter";
    @IntArg
    private final int maxLogToBreak;

    private LumberjackKit() {
        super("Lumberjack", Material.WOODEN_AXE);
        this.maxLogToBreak = 300;
        this.setMainKitItem(this.getDisplayMaterial(), true);
    }

    @Override
    @KitEvent
    public void onBlockBreakWithKitItem(BlockBreakEvent e) {
        String blockTypeName = e.getBlock().getType().name().toLowerCase();
        if ((blockTypeName.contains("wood") || blockTypeName.contains("log") || blockTypeName.contains("stem") || blockTypeName.contains("hyphae")) && !blockTypeName.contains("mushroom")) {
            KitPlayer player = KitApi.getInstance().getPlayer(e.getPlayer());
            player.putKitAttribute(this.logCounterKey, new AtomicInteger());
            this.breakSurroundingWood(e.getBlock(), player);
        }
    }

    public void breakSurroundingWood(Block block, KitPlayer kitPlayer) {
        String blockTypeName = block.getType().name().toLowerCase();
        if (blockTypeName.contains("wood") || blockTypeName.contains("log") || blockTypeName.contains("stem") || blockTypeName.contains("hyphae")) {
            BlockFace[] faces;
            block.breakNaturally();
            AtomicInteger count = (AtomicInteger)kitPlayer.getKitAttribute(this.logCounterKey);
            if (count.getAndIncrement() > this.maxLogToBreak) {
                return;
            }
            for (BlockFace face : faces = new BlockFace[]{BlockFace.DOWN, BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
                this.breakSurroundingWood(block.getRelative(face), kitPlayer);
            }
        }
    }
}

