/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.pvp.LastHitInformation;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;

public class KangarooKit
extends AbstractKit {
    public static final KangarooKit INSTANCE = new KangarooKit();
    @IntArg
    private final int boostUpPower;
    @IntArg
    private final int boostForwardPower;
    @IntArg
    private final int maxJumps;
    private final String jumpAmountKey;
    private final String sneakJumpKey;

    private KangarooKit() {
        super("Kangaroo", Material.FIREWORK_ROCKET);
        this.setMainKitItem(this.getDisplayMaterial());
        this.boostUpPower = 1;
        this.boostForwardPower = 1;
        this.maxJumps = 2;
        this.jumpAmountKey = this.getName() + "jumpAmount";
        this.sneakJumpKey = this.getName() + "hadSneakJump";
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute(this.jumpAmountKey, 0);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        this.handleKangarooEvent(event);
    }

    @Override
    @KitEvent
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        this.handleKangarooEvent(event);
    }

    @Override
    @KitEvent
    public void onPlayerMoveEvent(PlayerMoveEvent event, KitPlayer kitPlayer) {
        if (event.getPlayer().isOnGround() && kitPlayer.getKitAttributeOrDefault(this.jumpAmountKey, 0) > 0) {
            kitPlayer.putKitAttribute(this.jumpAmountKey, 0);
            kitPlayer.putKitAttribute(this.sneakJumpKey, false);
        }
    }

    private void handleKangarooEvent(PlayerInteractEvent event) {
        boolean jumpingAway;
        event.setCancelled(true);
        Player player = event.getPlayer();
        Vector direction = player.getLocation().getDirection();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        LastHitInformation lastHitInformation = kitPlayer.getLastHitInformation();
        Player otherPlayer = lastHitInformation.getLastPlayer();
        boolean isInCombat = kitPlayer.isInCombat();
        Integer currentJump = kitPlayer.getKitAttributeOrDefault(this.jumpAmountKey, 0);
        if (currentJump >= this.maxJumps) {
            return;
        }
        boolean bl = jumpingAway = otherPlayer != null && !this.isLookingAt(player, otherPlayer.getLocation().add(0.0, otherPlayer.getEyeHeight(), 0.0));
        if (isInCombat && jumpingAway) {
            player.sendMessage(Localization.t((String)"kangaroo.jumpingAway", (Locale)ChatUtils.locale((Player)player)));
            return;
        }
        if (player.isSneaking()) {
            if (kitPlayer.getKitAttributeOrDefault(this.sneakJumpKey, false).booleanValue()) {
                return;
            }
            Vector boost = direction.multiply(1.5 * (double)this.boostForwardPower).setY(0.6);
            player.setVelocity(boost);
            kitPlayer.putKitAttribute(this.sneakJumpKey, true);
        } else {
            if (isInCombat) {
                return;
            }
            player.setVelocity(player.getVelocity().setY(0.9 * (double)this.boostUpPower));
        }
        kitPlayer.putKitAttribute(this.jumpAmountKey, currentJump + 1);
    }

    private boolean isLookingAt(Player p, Location target) {
        Location head = p.getLocation().add(0.0, p.getEyeHeight(), 0.0);
        Vector look = p.getLocation().getDirection().normalize();
        if (p.getWorld() != target.getWorld()) {
            return false;
        }
        Vector direction = head.subtract(target).toVector().normalize();
        Vector boost = p.getLocation().getDirection().multiply(1.5).setY(0);
        Location newLocation = p.getLocation().add(boost);
        if (target.distance(newLocation) > target.distance(p.getLocation())) {
            return false;
        }
        Vector cp = direction.crossProduct(look);
        double length = cp.length();
        return length < 0.5;
    }
}

