/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.MaterialArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class JellyfishKit
extends AbstractKit
implements Listener {
    public static final JellyfishKit INSTANCE = new JellyfishKit();
    @IntArg
    private final int waterRemoveDeleay;
    @IntArg
    private final int maxUses;
    @FloatArg(min=0.0f)
    private final float cooldown;
    @MaterialArg
    private final Material liquidMaterial = Material.WATER;
    private static final ArrayList<Block> WATER_BLOCKS = new ArrayList();

    private JellyfishKit() {
        super("Jellyfish", Material.PUFFERFISH_BUCKET);
        this.maxUses = 10;
        this.cooldown = 30.0f;
        this.waterRemoveDeleay = 50;
    }

    @Override
    @KitEvent
    public void onPlayerRightClicksBlock(PlayerInteractEvent event, KitPlayer kitPlayer, Block block) {
        Player player = event.getPlayer();
        event.getClickedBlock().getRelative(BlockFace.UP).setType(this.liquidMaterial);
        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> {
            event.getClickedBlock().getRelative(BlockFace.UP).setType(Material.AIR);
            WATER_BLOCKS.remove(event.getClickedBlock().getRelative(BlockFace.UP));
        }, (long)this.waterRemoveDeleay);
        WATER_BLOCKS.add(event.getClickedBlock().getRelative(BlockFace.UP));
        KitApi.getInstance().checkUsesForCooldown(player, (AbstractKit)this, this.maxUses);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    @EventHandler
    @KitEvent(ignoreCooldown=true, clazz=BlockFromToEvent.class)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (event.getBlock().getType() == this.liquidMaterial && WATER_BLOCKS.contains(event.getBlock())) {
            event.setCancelled(true);
        }
    }
}

