/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;

public class HulkKit
extends AbstractKit
implements Listener {
    public static final HulkKit INSTANCE = new HulkKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @FloatArg(min=0.1f)
    private final float boostPower;

    private HulkKit() {
        super("Hulk", Material.PISTON);
        this.setMainKitItem(Material.AIR);
        this.cooldown = 3.0f;
        this.boostPower = 1.0f;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickEntityWithKitItem(PlayerInteractAtEntityEvent event, KitPlayer kitPlayer, Entity entity) {
        this.hulkEntity(event.getPlayer(), kitPlayer, entity);
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (player.getPassengers().size() > 0) {
            Entity hulkedEntity = (Entity)player.getPassengers().get(0);
            this.launchEntity(hulkedEntity, player);
        }
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onHitEntityWithKitItem(EntityDamageByEntityEvent event, KitPlayer attacker, Entity entity) {
        Player player = (Player)event.getDamager();
        if (player.getPassengers().size() > 0 && ((Entity)player.getPassengers().get(0)).equals(entity)) {
            event.setCancelled(true);
        }
        this.launchEntity(entity, player);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
            if (!kitPlayer.hasKit(this)) {
                return;
            }
            if (player.getPassengers().size() > 0 && ((Entity)player.getPassengers().get(0)).equals(event.getEntity())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (!(event.getEntered() instanceof Player)) {
            return;
        }
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer((Player)event.getEntered());
        if (kitPlayer.hasKit(this) && kitPlayer.getKitCooldown(this).hasCooldown()) {
            event.setCancelled(event.getVehicle() instanceof Boat || event.getVehicle() instanceof Minecart);
        }
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(player -> {
            List passengers = player.getPassengers();
            if (passengers.size() > 0) {
                passengers.forEach(arg_0 -> ((Player)player).removePassenger(arg_0));
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        event.getPlayer().leaveVehicle();
    }

    private void launchEntity(Entity hulkedEntity, Player player) {
        player.removePassenger(hulkedEntity);
        hulkedEntity.setVelocity(player.getLocation().getDirection().normalize().multiply(this.boostPower));
        if (hulkedEntity instanceof LivingEntity) {
            ((LivingEntity)hulkedEntity).setNoDamageTicks(10);
        }
    }

    private void hulkEntity(Player player, KitPlayer kitPlayer, Entity entity) {
        if (player.getPassengers().size() > 1) {
            return;
        }
        player.addPassenger(entity);
        kitPlayer.activateKitCooldown(this);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

