/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.LongArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class HemomancerKit
extends AbstractKit {
    public static final HemomancerKit INSTANCE = new HemomancerKit();
    @LongArg
    private final long startDelay;
    @LongArg
    private final long period;
    @DoubleArg
    private final double radius;
    @DoubleArg
    private final double healthGain;
    @DoubleArg
    private final double healthLoss;
    private BukkitTask task;

    private HemomancerKit() {
        super("Hemomancer", Material.CRIMSON_FUNGUS);
        this.startDelay = 0L;
        this.period = 20L;
        this.radius = 5.0;
        this.healthLoss = 1.0;
        this.healthGain = 1.0;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), () -> {
            if (kitPlayer.isInCombat() && kitPlayer.getBukkitPlayer().isPresent()) {
                Player player = kitPlayer.getBukkitPlayer().get();
                for (KitPlayer enemy : this.getKitPlayersInRadius(player, this.radius)) {
                    if (!enemy.getBukkitPlayer().isPresent()) continue;
                    Player enemyPlayer = enemy.getBukkitPlayer().get();
                    this.safeSetHealth(enemyPlayer, enemyPlayer.getHealth() - this.healthLoss);
                    this.safeSetHealth(player, player.getHealth() + this.healthGain);
                }
            }
        }, this.startDelay, this.period);
    }

    private void safeSetHealth(Player player, double health) {
        AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (maxHealthAttribute != null) {
            double maxHealth = maxHealthAttribute.getValue();
            if (health > maxHealth) {
                player.setHealth(maxHealth);
                return;
            }
            if (health < 0.0) {
                return;
            }
            player.setHealth(health);
        }
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        if (this.task != null) {
            Bukkit.getScheduler().cancelTask(this.task.getTaskId());
        }
    }
}

