/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GravityKit
extends AbstractKit {
    public static final GravityKit INSTANCE = new GravityKit();
    @IntArg
    private final int maxUses;
    @IntArg(min=0)
    private final int gravityAmplifier;
    @IntArg(min=1)
    private final int targetGravityDuration;
    @IntArg(min=20)
    private final int gravityDuration;
    @IntArg(min=0)
    private final int combatGravityDuration;
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg(min=0, max=10)
    private final int inCombatCheckTimeout;

    private GravityKit() {
        super("Gravity", Material.MAGENTA_GLAZED_TERRACOTTA);
        this.setMainKitItem(this.getDisplayMaterial());
        this.cooldown = 30.0f;
        this.maxUses = 3;
        this.gravityAmplifier = 3;
        this.targetGravityDuration = 1;
        this.inCombatCheckTimeout = 5;
        this.gravityDuration = 30;
        this.combatGravityDuration = 4;
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player != null && player.hasPotionEffect(PotionEffectType.LEVITATION)) {
            player.removePotionEffect(PotionEffectType.LEVITATION);
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (player.hasPotionEffect(PotionEffectType.LEVITATION)) {
            kitPlayer.activateKitCooldown(this);
            player.removePotionEffect(PotionEffectType.LEVITATION);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, (kitPlayer.isInCombat(this.inCombatCheckTimeout) ? this.combatGravityDuration : this.gravityDuration) * 20, this.gravityAmplifier));
    }

    @Override
    @KitEvent
    public void onHitLivingEntityWithKitItem(EntityDamageByEntityEvent event, KitPlayer attacker, LivingEntity entity) {
        entity.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20 * this.targetGravityDuration, this.gravityAmplifier));
        KitApi.getInstance().checkUsesForCooldown(attacker, (AbstractKit)this, this.maxUses);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

