/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import de.hglabor.utils.noriskutils.RandomCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GamblerKit
extends AbstractKit
implements Listener {
    public static final GamblerKit INSTANCE = new GamblerKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    private final RandomCollection<RandomCollection<Consumer<Player>>> badLuckCollection;
    private final RandomCollection<RandomCollection<Consumer<Player>>> goodLuckCollection;
    private final String attributeKey;
    private final String gamblerAnimal;

    private GamblerKit() {
        super("Gambler", Material.OAK_BUTTON);
        this.setMainKitItem(this.getDisplayMaterial());
        this.cooldown = 30.0f;
        this.attributeKey = this.getName() + "Win";
        this.gamblerAnimal = this.getName() + "gamblerAnimal";
        this.badLuckCollection = new RandomCollection();
        this.goodLuckCollection = new RandomCollection();
        this.initRandomEffects();
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        GambleWin gambleWin = (GambleWin)((Object)kitPlayer.getKitAttribute(this.attributeKey));
        if (gambleWin != null) {
            gambleWin.end();
        }
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        GambleWin gambleWin = (GambleWin)((Object)kitPlayer.getKitAttribute(this.attributeKey));
        if (gambleWin != null) {
            gambleWin.end();
        }
        kitPlayer.getBukkitPlayer().ifPresent(player -> {
            player.setGravity(true);
            for (Tameable tameable : player.getWorld().getEntitiesByClass(Tameable.class)) {
                if (tameable.getOwnerUniqueId() == null || !tameable.getOwnerUniqueId().equals(player.getUniqueId()) || !tameable.hasMetadata(this.gamblerAnimal)) continue;
                tameable.remove();
            }
        });
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        int tick = 2;
        kitPlayer.activateKitCooldown(this);
        GambleWin gambleWin = new GambleWin(kitPlayer, player, 3, tick);
        kitPlayer.putKitAttribute(this.attributeKey, gambleWin);
        gambleWin.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, tick);
    }

    private void initRandomEffects() {
        int potionDauer = 200;
        RandomCollection badItems = new RandomCollection();
        badItems.add("\u00a76Pumpkin Head", 0.75, p -> p.getInventory().setHelmet(new ItemStack(Material.CARVED_PUMPKIN)));
        badItems.add("\u00a76Dragon Head", 0.4, p -> p.getInventory().setHelmet(new ItemStack(Material.DRAGON_HEAD)));
        badItems.add("\u00a76Pumpkin Head (trololol)", 0.075, p -> {
            ItemStack pumpkin = new ItemStack(Material.CARVED_PUMPKIN);
            ItemMeta pumpkinMeta = pumpkin.getItemMeta();
            pumpkinMeta.addEnchant(Enchantment.BINDING_CURSE, 1, true);
            pumpkin.setItemMeta(pumpkinMeta);
            p.getInventory().setHelmet(new ItemStack(pumpkin));
        });
        badItems.add("\u00a78Dirt", 1.0, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.DIRT, 16))));
        badItems.add("\u00a78Dried Kelp", 1.0, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.DRIED_KELP_BLOCK))));
        badItems.add("\u00a72Seeds", 1.0, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.WHEAT_SEEDS, 16))));
        RandomCollection cantBeClassifiedBad = new RandomCollection();
        cantBeClassifiedBad.add("\u00a74\u00a7lInstant Death", 0.01, p -> p.teleport(new Location(p.getWorld(), p.getLocation().getX(), -1.0, p.getLocation().getZ())));
        cantBeClassifiedBad.add("\u00a79\u00a7lRandom TP", 0.3, p -> KitApi.getInstance().getRandomAlivePlayer().getBukkitPlayer().ifPresent(it -> p.teleport(it.getLocation())));
        cantBeClassifiedBad.add("\u00a7c\u00a7lNo Gravity", 0.3, p -> p.setGravity(false));
        cantBeClassifiedBad.add("\u00a7l\u00a72Charged Creeper", 0.1, p -> {
            Creeper creeper = (Creeper)p.getWorld().spawnEntity(p.getLocation(), EntityType.CREEPER);
            creeper.setPowered(true);
        });
        cantBeClassifiedBad.add("\u00a72Creeper", 0.25, p -> p.getWorld().spawnEntity(p.getLocation(), EntityType.CREEPER));
        cantBeClassifiedBad.add("\u00a77Nix", 0.5, p -> {});
        cantBeClassifiedBad.add("\u00a70Wither", 0.001, p -> p.getWorld().spawnEntity(p.getLocation(), EntityType.WITHER));
        cantBeClassifiedBad.add("\u00a77Lesestunde", 0.2, p -> p.getLocation().getBlock().setType(Material.LECTERN));
        cantBeClassifiedBad.add("\u00a70MLG", 0.1, p -> {
            int x = (int)p.getLocation().getX();
            int z = (int)p.getLocation().getZ();
            p.teleport(new Location(p.getWorld(), (double)x, (double)(p.getWorld().getHighestBlockYAt(x, z) + 30), (double)z));
            KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.WATER_BUCKET)));
        });
        cantBeClassifiedBad.add("\u00a7cLava", 0.25, p -> p.getLocation().getBlock().setType(Material.LAVA));
        cantBeClassifiedBad.add("Random Teleport", 0.2, p -> KitApi.getInstance().getRandomAlivePlayer().getBukkitPlayer().ifPresent(player -> p.teleport(player.getLocation())));
        cantBeClassifiedBad.add("Coords Leak", 0.5, p -> {
            Location location = p.getLocation();
            String x = String.valueOf(location.getBlockX());
            String y = String.valueOf(location.getBlockY());
            String z = String.valueOf(location.getBlockZ());
            ChatUtils.broadcastMessage((String)Localization.INSTANCE.getMessage("gambler.coordsLeak", (Map)ImmutableMap.of((Object)"x", (Object)x, (Object)"y", (Object)y, (Object)"z", (Object)z, (Object)"playerName", (Object)p.getName()), ChatUtils.locale((Player)p)));
        });
        RandomCollection badPotionEffects = new RandomCollection();
        badPotionEffects.add("\u00a7aPoison", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.POISON, potionDauer, 0)));
        badPotionEffects.add("\u00a77Weakness", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, potionDauer, 0)));
        badPotionEffects.add("\u00a7dLevitation", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, potionDauer, 0)));
        badPotionEffects.add("\u00a70Blindness", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, potionDauer, 0)));
        badPotionEffects.add("\u00a78Slowness", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, potionDauer, 0)));
        badPotionEffects.add("\u00a78Glowing", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, potionDauer, 0)));
        this.badLuckCollection.add(0.5, (Object)cantBeClassifiedBad);
        this.badLuckCollection.add(1.0, (Object)badPotionEffects);
        this.badLuckCollection.add(1.0, (Object)badItems);
        RandomCollection goodPotionEffects = new RandomCollection();
        goodPotionEffects.add("\u00a7cStrength", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, potionDauer, 0)));
        goodPotionEffects.add("\u00a7eFire Resistance", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, potionDauer, 0)));
        goodPotionEffects.add("\u00a73Damage Resistance", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, potionDauer, 0)));
        goodPotionEffects.add("\u00a7bSpeed", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, potionDauer, 1)));
        goodPotionEffects.add("Invisibility", 1.0, p -> p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, potionDauer, 0)));
        RandomCollection goodItems = new RandomCollection();
        goodItems.add("\u00a76Wood", 0.7, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.OAK_PLANKS, 32))));
        goodItems.add("\u00a77Elytra", 0.02, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.ELYTRA))));
        goodItems.add("\u00a76Recraft", 0.75, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.RED_MUSHROOM, 16), new ItemStack(Material.BROWN_MUSHROOM, 16), new ItemStack(Material.BOWL, 16))));
        goodItems.add("\u00a79Water Bucket", 0.3, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.WATER_BUCKET))));
        goodItems.add("\u00a79Fish Bucket", 0.2, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.PUFFERFISH_BUCKET))));
        goodItems.add("\u00a78Steak", 0.3, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.COOKED_BEEF, 32))));
        goodItems.add("\u00a79Fishing Rod", 0.3, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemBuilder(Material.FISHING_ROD).setEnchantment(Enchantment.LUCK, 3).build())));
        goodItems.add("$fIron Sword", 0.15, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.IRON_SWORD, 1))));
        goodItems.add("\u00a76Golden Apple", 0.3, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.GOLDEN_APPLE, 1))));
        goodItems.add("\u00a71Backpack", 0.075, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.SHULKER_BOX, 1))));
        goodItems.add("\u00a73Enderpearl", 0.3, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.ENDER_PEARL, 1))));
        goodItems.add("\u00a7bDiamond Sword", 0.125, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.DIAMOND_SWORD, 1))));
        goodItems.add("\u00a76Revive", 0.05, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Collections.singletonList(new ItemStack(Material.TOTEM_OF_UNDYING, 1))));
        goodItems.add("\u00a75End Crystal", 0.05, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.END_CRYSTAL, 1), new ItemStack(Material.OBSIDIAN, 1))));
        goodItems.add("\u00a77Bow", 0.2, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.BOW, 1), new ItemStack(Material.ARROW, 5))));
        goodItems.add("\u00a7bDiamond Set", 0.002, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.DIAMOND_BOOTS, 1), new ItemStack(Material.DIAMOND_LEGGINGS, 1), new ItemStack(Material.DIAMOND_CHESTPLATE, 1), new ItemStack(Material.DIAMOND_HELMET, 1), new ItemStack(Material.DIAMOND_SWORD, 1))));
        goodItems.add("\u00a77Chain Set", 0.2, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.CHAINMAIL_BOOTS, 1), new ItemStack(Material.CHAINMAIL_LEGGINGS, 1), new ItemStack(Material.CHAINMAIL_CHESTPLATE, 1), new ItemStack(Material.CHAINMAIL_HELMET, 1), new ItemStack(Material.STONE_SWORD, 1))));
        goodItems.add("\u00a76Golden Set", 0.25, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.GOLDEN_BOOTS, 1), new ItemStack(Material.GOLDEN_LEGGINGS, 1), new ItemStack(Material.GOLDEN_CHESTPLATE, 1), new ItemStack(Material.GOLDEN_HELMET, 1), new ItemStack(Material.GOLDEN_SWORD, 1))));
        goodItems.add("\u00a7fIron Set", 0.075, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.IRON_BOOTS, 1), new ItemStack(Material.IRON_LEGGINGS, 1), new ItemStack(Material.IRON_CHESTPLATE, 1), new ItemStack(Material.IRON_HELMET, 1), new ItemStack(Material.IRON_SWORD, 1))));
        goodItems.add("\u00a73Coco Set", 0.5, p -> KitApi.getInstance().giveKitItemsIfInvFull(KitApi.getInstance().getPlayer((Player)p), this, Arrays.asList(new ItemStack(Material.COCOA_BEANS, 16), new ItemStack(Material.JUNGLE_LOG, 4))));
        goodItems.add("\u00a76WOBLE", 0.05, p -> p.getInventory().setHelmet(this.getWombleHead()));
        RandomCollection cantBeClassified = new RandomCollection();
        cantBeClassified.add("\u00a7dDoggos", 1.0, p -> {
            Wolf wolf = (Wolf)p.getWorld().spawnEntity(p.getLocation(), EntityType.WOLF);
            wolf.setMetadata(this.gamblerAnimal, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            wolf.setOwner((AnimalTamer)p);
        });
        cantBeClassified.add("\u00a74Mooshroom", 1.0, p -> p.getWorld().spawnEntity(p.getLocation(), EntityType.MUSHROOM_COW));
        cantBeClassified.add("\u00a77Boat", 1.0, p -> p.getWorld().spawnEntity(p.getLocation(), EntityType.BOAT));
        cantBeClassified.add("\u00a75Horse", 0.1, p -> {
            ZombieHorse horse = (ZombieHorse)p.getWorld().spawnEntity(p.getLocation(), EntityType.ZOMBIE_HORSE);
            horse.setTamed(true);
            horse.setOwner((AnimalTamer)p);
            horse.setMetadata(this.gamblerAnimal, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            horse.getInventory().setSaddle(new ItemStack(Material.SADDLE));
        });
        cantBeClassified.add("\u00a77Normie\u00a7a+", 5.0E-4, p -> {
            ChatUtils.broadcastMessage((String)(ChatColor.GREEN + p.getName() + " won Normie+"));
            p.sendMessage(Localization.INSTANCE.getMessage("gambler.wonNormiePlus", ChatUtils.locale((Player)p)));
        });
        this.goodLuckCollection.add(1.0, (Object)goodPotionEffects);
        this.goodLuckCollection.add(1.0, (Object)goodItems);
        this.goodLuckCollection.add(0.75, (Object)cantBeClassified);
    }

    private ItemStack getWombleHead() {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwner("Wxmble");
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    private class GambleWin
    extends BukkitRunnable {
        private final long END;
        private final Player player;
        private final KitPlayer kitPlayer;
        private final Random random;
        private final int tick;
        private boolean forceEnd;

        public GambleWin(KitPlayer kitPlayer, Player player, int gambleDuration, int tick) {
            this.player = player;
            this.kitPlayer = kitPlayer;
            this.random = new Random();
            this.tick = tick;
            this.END = System.currentTimeMillis() + (long)gambleDuration * 1000L;
        }

        public void run() {
            if (this.forceEnd) {
                return;
            }
            boolean goodOrBad = this.random.nextBoolean();
            RandomCollection randomCollection = goodOrBad ? (RandomCollection)GamblerKit.INSTANCE.goodLuckCollection.getRandom() : (RandomCollection)GamblerKit.INSTANCE.badLuckCollection.getRandom();
            Consumer randomEffect = (Consumer)randomCollection.getRandom();
            String name = randomCollection.getName((Object)randomEffect);
            if (System.currentTimeMillis() >= this.END) {
                randomEffect.accept(this.player);
                this.player.sendTitle("", name, 0, 20, 0);
                this.player.playSound(this.player.getLocation(), goodOrBad ? Sound.ENTITY_PLAYER_LEVELUP : Sound.ENTITY_DONKEY_HURT, 0.8f, 1.0f);
                this.cancel();
            } else {
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_BAMBOO_BREAK, 0.8f, 0.75f + this.random.nextFloat() / 2.0f);
                this.player.sendTitle("", name, 0, this.tick, 0);
            }
        }

        public void end() {
            this.kitPlayer.putKitAttribute(GamblerKit.this.attributeKey, null);
            this.forceEnd = true;
            this.cancel();
        }
    }
}

