/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.RotationUtils;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class EyecatcherKit
extends AbstractKit
implements Listener {
    public static final EyecatcherKit INSTANCE = new EyecatcherKit();
    @DoubleArg
    private final double radius;
    @IntArg
    private final int duration;
    @FloatArg
    private final float cooldown;

    private EyecatcherKit() {
        super("Eyecatcher", Material.ENDER_EYE);
        this.setMainKitItem(this.getDisplayMaterial());
        this.radius = 15.0;
        this.duration = 5;
        this.cooldown = 25.0f;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        AtomicInteger tick = new AtomicInteger(0);
        Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), task -> {
            tick.getAndIncrement();
            if (tick.get() == this.duration * 20) {
                task.cancel();
                return;
            }
            if (!kitPlayer.isValid()) {
                task.cancel();
                return;
            }
            if (kitPlayer.areKitsDisabled()) {
                task.cancel();
                return;
            }
            player.getNearbyEntities(this.radius, this.radius, this.radius).forEach(it -> {
                RotationUtils.Rotation rotation = RotationUtils.getNeededRotations((Entity)player, it);
                if (it instanceof Player) {
                    Location location = it.getLocation().clone();
                    location.setYaw(rotation.getYaw());
                    location.setPitch(rotation.getPitch());
                } else {
                    it.setRotation(rotation.getYaw(), rotation.getPitch());
                }
            });
        }, 0L, 1L);
        kitPlayer.activateKitCooldown(INSTANCE);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

