/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.events.KitEventHandler;
import de.hglabor.plugins.kitapi.kit.kits.TankKit;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DemomanKit
extends AbstractKit
implements Listener {
    public static final DemomanKit INSTANCE = new DemomanKit();
    @FloatArg(min=0.1f, max=100.0f)
    private final float sandExplosionSize;
    @FloatArg(min=0.1f, max=100.0f)
    private final float gravelExplosionSize;
    @FloatArg(min=0.1f, max=100.0f)
    private final float concreteExplosionSize;
    private final String demomanPlateKey;
    private final String allPlatesKey;
    private final String currentlyDisabledKey;

    private DemomanKit() {
        super("Demoman", Material.GRAVEL);
        this.addAdditionalKitItems(new ItemStack(Material.GRAVEL, 8));
        this.addAdditionalKitItems(new ItemStack(Material.STONE_PRESSURE_PLATE, 8));
        this.setKitItemPlaceable(true);
        this.sandExplosionSize = 1.0f;
        this.gravelExplosionSize = 4.0f;
        this.concreteExplosionSize = 9.0f;
        this.demomanPlateKey = "demomanPlate";
        this.allPlatesKey = "allPlates";
        this.currentlyDisabledKey = "currentyDisabled";
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute(this.currentlyDisabledKey, false);
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute(this.currentlyDisabledKey, true);
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        List allPlates = kitPlayer.getKitAttributeOrDefault(this.allPlatesKey, new ArrayList());
        for (Block block : allPlates) {
            if (!block.hasMetadata(this.demomanPlateKey)) continue;
            block.setMetadata(this.demomanPlateKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
        }
    }

    @KitEvent
    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block eventBlock = event.getBlock();
        Player player = event.getPlayer();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!kitPlayer.hasKit(this)) {
            return;
        }
        if (!(Tag.WOODEN_PRESSURE_PLATES.isTagged((Keyed)eventBlock.getType()) || Tag.STONE_PRESSURE_PLATES.isTagged((Keyed)eventBlock.getType()) || Tag.CARPETS.isTagged((Keyed)eventBlock.getType()))) {
            return;
        }
        if (!KitEventHandler.canUseKit((Event)event, kitPlayer, this)) {
            return;
        }
        event.getBlockPlaced().setMetadata(this.demomanPlateKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)player.getName()));
        List allPlates = kitPlayer.getKitAttributeOrDefault(this.allPlatesKey, new ArrayList());
        allPlates.add(event.getBlockPlaced());
        kitPlayer.putKitAttribute(this.allPlatesKey, allPlates);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        KitPlayer plateOwnerKitPlayer;
        Player player = event.getPlayer();
        if (!player.isOnGround()) {
            return;
        }
        if (event.getTo().distanceSquared(event.getFrom()) == 0.0) {
            return;
        }
        Block eventBlock = event.getTo().getBlock();
        if (!(Tag.WOODEN_PRESSURE_PLATES.isTagged((Keyed)eventBlock.getType()) || Tag.STONE_PRESSURE_PLATES.isTagged((Keyed)eventBlock.getType()) || Tag.CARPETS.isTagged((Keyed)eventBlock.getType()))) {
            return;
        }
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!kitPlayer.isValid()) {
            return;
        }
        if (kitPlayer.hasKit(TankKit.INSTANCE)) {
            return;
        }
        if (!eventBlock.hasMetadata(this.demomanPlateKey)) {
            return;
        }
        String plateOwnerName = ((MetadataValue)eventBlock.getMetadata(this.demomanPlateKey).get(0)).asString();
        if (plateOwnerName.equals(event.getPlayer().getName())) {
            return;
        }
        Player plateOwner = Bukkit.getPlayer((String)plateOwnerName);
        if (plateOwner != null && (plateOwnerKitPlayer = KitApi.getInstance().getPlayer(plateOwner)).getKitAttributeOrDefault(this.currentlyDisabledKey, false).booleanValue()) {
            return;
        }
        if (Tag.WOODEN_PRESSURE_PLATES.isTagged((Keyed)eventBlock.getType())) {
            if (eventBlock.getRelative(BlockFace.DOWN).getType() != Material.SAND) {
                return;
            }
            eventBlock.setType(Material.AIR);
            eventBlock.getWorld().createExplosion(eventBlock.getLocation(), this.sandExplosionSize);
        }
        if (Tag.STONE_PRESSURE_PLATES.isTagged((Keyed)eventBlock.getType())) {
            if (eventBlock.getRelative(BlockFace.DOWN).getType() != Material.GRAVEL) {
                return;
            }
            eventBlock.setType(Material.AIR);
            eventBlock.getWorld().createExplosion(eventBlock.getLocation(), this.gravelExplosionSize);
        }
        if (Tag.CARPETS.isTagged((Keyed)eventBlock.getType())) {
            String carpetColor = eventBlock.getType().name().split("_")[0];
            Block concretePowder = eventBlock.getRelative(BlockFace.DOWN);
            if (!concretePowder.getType().name().endsWith("CONCRETE_POWDER")) {
                return;
            }
            String concreteColor = concretePowder.getType().name().split("_CONCRETE_POWDER")[0];
            if (concreteColor.equals(carpetColor)) {
                eventBlock.setType(Material.AIR);
                concretePowder.setType(Material.AIR);
                eventBlock.getWorld().createExplosion(eventBlock.getLocation(), this.concreteExplosionSize);
            }
        }
    }
}

