/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class DarknessKit
extends AbstractKit {
    public static final DarknessKit INSTANCE = new DarknessKit();
    @IntArg
    private final int radius;
    private static final String bukkitTaskKey = "bukkitTask";
    private static final ArrayList<ArmorStand> DARK_SPOTS = new ArrayList();

    private DarknessKit() {
        super("Darkness", Material.BLACK_STAINED_GLASS);
        this.radius = 50;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return;
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), () -> {
            for (LivingEntity nearby : player.getWorld().getNearbyLivingEntities(player.getLocation(), (double)this.radius)) {
                KitPlayer nearbyKitPlayer;
                if (!(nearby instanceof Player) || !(nearbyKitPlayer = KitApi.getInstance().getPlayer((Player)nearby)).isValid() || nearby.getUniqueId() == player.getUniqueId() || nearby.getTargetEntity(this.radius).getUniqueId() != player.getUniqueId()) continue;
                nearby.getWorld().spawnParticle(Particle.REDSTONE, nearby.getEyeLocation(), 5, (Object)new Particle.DustOptions(Color.BLACK, 3.0f));
                nearby.addPotionEffect(new PotionEffect(PotionEffectType.BAD_OMEN, 30, 2, false, false));
                nearby.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 30, 2, false, false));
            }
        }, 0L, 1L);
        kitPlayer.putKitAttribute(bukkitTaskKey, task);
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        BukkitTask bukkitTask = (BukkitTask)kitPlayer.getKitAttribute(bukkitTaskKey);
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        BukkitTask bukkitTask = (BukkitTask)kitPlayer.getKitAttribute(bukkitTaskKey);
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
    }
}

