/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.events.event.PlayerAteSoupEvent;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@BetaKit
public class ChemistKit
extends AbstractKit
implements Listener {
    public static final ChemistKit INSTANCE = new ChemistKit();
    private final NamespacedKey namespacedKey = new NamespacedKey((Plugin)KitApi.getInstance().getPlugin(), "chemistSoup");
    private final List<PotionEffectType> potionEffects = Arrays.asList(PotionEffectType.POISON, PotionEffectType.HUNGER, PotionEffectType.CONFUSION, PotionEffectType.BLINDNESS, PotionEffectType.WITHER, PotionEffectType.GLOWING, PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS);
    @IntArg
    private final int durationInSeconds;
    @IntArg
    private final int amplifier;

    private ChemistKit() {
        super("Chemist", new ItemBuilder(Material.POTION).setPotionEffect(PotionEffectType.CONFUSION, Color.GREEN).build());
        this.durationInSeconds = 10;
        this.amplifier = 3;
    }

    @EventHandler
    public void onPlayerAteSoup(PlayerAteSoupEvent event) {
        ItemStack soup = event.getSoup();
        if (!soup.hasItemMeta()) {
            return;
        }
        String uuidString = (String)soup.getItemMeta().getPersistentDataContainer().get(this.namespacedKey, PersistentDataType.STRING);
        if (uuidString != null) {
            Player player = event.getPlayer();
            if (player.getUniqueId().toString().equalsIgnoreCase(uuidString)) {
                return;
            }
            UUID uuid = UUID.fromString(uuidString);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            player.sendMessage(ChatColor.RED + "Du hast die vergiftete Suppe von " + offlinePlayer.getName() + " gegessen");
            PotionEffect randomPotionEffect = this.getRandomPotionEffect();
            player.addPotionEffect(randomPotionEffect);
            Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).ifPresent(chemist -> chemist.sendMessage(ChatColor.GREEN + player.getName() + " hat " + ChatColor.GOLD + randomPotionEffect.getType().getName() + ChatColor.GREEN + " durch eine deiner vergifteten Suppen bekommen"));
        }
    }

    @Override
    @KitEvent
    public void onDropItem(PlayerDropItemEvent event, KitPlayer kitPlayer) {
        Item itemDrop = event.getItemDrop();
        ItemStack itemStack = itemDrop.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(this.namespacedKey, PersistentDataType.STRING, (Object)kitPlayer.getUUID().toString());
        itemStack.setItemMeta(itemMeta);
        event.getItemDrop().setItemStack(itemStack);
    }

    private PotionEffect getRandomPotionEffect() {
        return this.potionEffects.get(ThreadLocalRandom.current().nextInt(this.potionEffects.size())).createEffect(this.durationInSeconds * 20, this.amplifier);
    }
}

