/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.BoolArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ItemBuilder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BomberKit
extends AbstractKit {
    public static final BomberKit INSTANCE = new BomberKit();
    private final ItemStack BOMB = new ItemBuilder(Material.TNT).setName(ChatColor.DARK_GRAY + "Bomb").build();
    @IntArg
    private final int bombAmount;
    @IntArg
    private final int explosionDelay;
    @FloatArg
    private final float explosionPower;
    @BoolArg
    private final boolean makeFire;
    private final String remainingBombKey = "remainingBombs";

    private BomberKit() {
        super("Bomber", Material.TNT_MINECART);
        this.setMainKitItem(this.BOMB);
        this.bombAmount = 3;
        this.explosionDelay = 5;
        this.explosionPower = 4.0f;
        this.makeFire = true;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute("remainingBombs", this.bombAmount);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        Integer remainingBombs = (Integer)kitPlayer.getKitAttribute("remainingBombs");
        if (remainingBombs != null && remainingBombs > 0) {
            Item bomb = player.getWorld().dropItem(player.getLocation(), this.BOMB);
            bomb.setCanPlayerPickup(false);
            bomb.setCanMobPickup(false);
            bomb.setVelocity(player.getLocation().getDirection().multiply(0.7).setY(0.2));
            remainingBombs = remainingBombs - 1;
            kitPlayer.putKitAttribute("remainingBombs", remainingBombs);
            Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> bomb.getWorld().createExplosion((Entity)player, bomb.getLocation(), this.explosionPower, this.makeFire, true), (long)this.explosionDelay * 20L);
            return;
        }
        player.sendMessage(Component.text((String)"Kill someone to get new bombs").color(TextColor.color((int)255, (int)0, (int)0)));
    }

    @Override
    @KitEvent(clazz=PlayerDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        Integer remainingBombs = (Integer)killer.getKitAttribute("remainingBombs");
        if (remainingBombs != null) {
            killer.putKitAttribute("remainingBombs", remainingBombs + 1);
        }
    }
}

