/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BerserkerKit
extends AbstractKit {
    public static final BerserkerKit INSTANCE = new BerserkerKit();
    @IntArg
    private final int playerStrengthDuration;
    @IntArg
    private final int playerStrengthAmplifier;
    @IntArg
    private final int playerSpeedDuration;
    @IntArg
    private final int playerSpeedAmplifier;
    @IntArg
    private final int mobStrengthDuration;
    @IntArg
    private final int mobStrengthAmplifier;
    @IntArg
    private final int mobSpeedDuration;
    @IntArg
    private final int mobSpeedAmplifier;

    private BerserkerKit() {
        super("Berserker", Material.BLAZE_POWDER);
        this.playerStrengthDuration = 12;
        this.playerStrengthAmplifier = 1;
        this.playerSpeedDuration = 8;
        this.playerSpeedAmplifier = 2;
        this.mobStrengthDuration = 4;
        this.mobStrengthAmplifier = 1;
        this.mobSpeedDuration = 4;
        this.mobSpeedAmplifier = 1;
    }

    @Override
    @KitEvent
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        Player killerPlayer = Bukkit.getPlayer((UUID)killer.getUUID());
        if (killerPlayer != null) {
            killerPlayer.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 20 * this.playerStrengthDuration, this.playerStrengthAmplifier));
            killerPlayer.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 20 * this.playerSpeedDuration, this.playerSpeedAmplifier));
        }
    }

    @Override
    @KitEvent
    public void onPlayerKillsLivingEntity(EntityDeathEvent event, Player killer, Entity entity) {
        killer.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 20 * this.mobStrengthDuration, this.mobStrengthAmplifier));
        killer.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 20 * this.mobSpeedDuration, this.mobSpeedAmplifier));
    }
}

