/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BarbarianKit
extends AbstractKit {
    public static final BarbarianKit INSTANCE = new BarbarianKit();
    @IntArg
    private final int moduloSteps;
    private final String killsKey = this.getName() + "kills";
    private final String levelKey = this.getName() + "level";

    private BarbarianKit() {
        super("Barbarian", Material.WOODEN_SWORD);
        this.moduloSteps = 1;
        this.setMainKitItem(new ItemBuilder(Material.WOODEN_SWORD).setLocalizedName(this.getName()).setUnbreakable(true).build());
    }

    @Override
    @KitEvent(clazz=PlayerDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        Player player = Bukkit.getPlayer((UUID)killer.getUUID());
        if (player == null) {
            return;
        }
        ItemStack barbarianSword = player.getInventory().getItemInMainHand();
        if (!this.isKitItem(barbarianSword)) {
            return;
        }
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        kitPlayer.putKitAttribute(this.killsKey, kitPlayer.getKitAttributeOrDefault(this.killsKey, 0) + 1);
        if ((Integer)kitPlayer.getKitAttribute(this.killsKey) % this.moduloSteps == 0) {
            switch (kitPlayer.getKitAttributeOrDefault(this.levelKey, 1)) {
                case 1: {
                    barbarianSword.setType(Material.STONE_SWORD);
                    break;
                }
                case 2: {
                    barbarianSword.setType(Material.WOODEN_SWORD);
                    barbarianSword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                    break;
                }
                case 3: {
                    barbarianSword.removeEnchantment(Enchantment.DAMAGE_ALL);
                    barbarianSword.setType(Material.IRON_SWORD);
                    break;
                }
                case 4: {
                    barbarianSword.setType(Material.STONE_SWORD);
                    barbarianSword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                    break;
                }
                case 5: {
                    barbarianSword.setType(Material.DIAMOND_SWORD);
                    break;
                }
                case 6: {
                    barbarianSword.setType(Material.IRON_SWORD);
                    barbarianSword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                    break;
                }
                case 7: {
                    barbarianSword.setType(Material.DIAMOND_SWORD);
                    barbarianSword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                    break;
                }
                case 8: {
                    barbarianSword.setType(Material.DIAMOND_SWORD);
                    barbarianSword.addEnchantment(Enchantment.DAMAGE_ALL, 2);
                    break;
                }
                case 9: {
                    barbarianSword.setType(Material.DIAMOND_SWORD);
                    barbarianSword.addEnchantment(Enchantment.FIRE_ASPECT, 1);
                }
            }
            kitPlayer.putKitAttribute(this.levelKey, kitPlayer.getKitAttributeOrDefault(this.levelKey, 1) + 1);
        }
    }

    @Override
    public boolean isKitItem(ItemStack itemStack) {
        ItemMeta itemMeta;
        if (itemStack.hasItemMeta() && (itemMeta = itemStack.getItemMeta()).hasLocalizedName()) {
            return itemMeta.getLocalizedName().equalsIgnoreCase(this.getName());
        }
        return false;
    }
}

