/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChanceUtils;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArcherKit
extends AbstractKit
implements Listener {
    public static final ArcherKit INSTANCE = new ArcherKit();
    @IntArg(min=0)
    private final int effectDurationInSeconds;
    @IntArg(min=0)
    private final int effectAmplifier;
    @IntArg(min=0, max=64)
    private final int arrows;
    @IntArg(min=0, max=100)
    private final int effectLikelihood;
    private final List<PotionEffectType> potionEffectTypes;

    private ArcherKit() {
        super("Archer", Material.BOW);
        this.setKitItemPlaceable(true);
        this.effectDurationInSeconds = 4;
        this.arrows = 6;
        this.effectAmplifier = 0;
        this.potionEffectTypes = Arrays.asList(PotionEffectType.BLINDNESS, PotionEffectType.SLOW_FALLING, PotionEffectType.LEVITATION, PotionEffectType.REGENERATION, PotionEffectType.SLOW_DIGGING, PotionEffectType.HUNGER, PotionEffectType.CONFUSION, PotionEffectType.GLOWING, PotionEffectType.WITHER, PotionEffectType.POISON, PotionEffectType.INCREASE_DAMAGE);
        this.effectLikelihood = 50;
        this.mainKitItem = new KitItemBuilder(Material.BOW).setUnbreakable(true).build();
        this.addAdditionalKitItems(new ItemStack(Material.ARROW, this.arrows));
    }

    @Override
    @KitEvent
    public void onProjectileHitEvent(ProjectileHitEvent event, KitPlayer kitPlayer, Entity hitEntity) {
        if (hitEntity instanceof LivingEntity) {
            kitPlayer.getBukkitPlayer().ifPresent(player -> {
                KitApi.getInstance().giveItemsIfSlotEmpty(kitPlayer, List.of(new ItemStack(Material.ARROW, 1)));
                Map<String, String> hearts = Map.of("hearts", String.valueOf((int)((LivingEntity)hitEntity).getHealth()), "name", hitEntity.getName());
                String key = "archer.hit";
                Locale playerLocale = ChatUtils.locale((Player)player);
                player.sendMessage(Localization.t((String)key, hearts, (Locale)playerLocale));
            });
        }
    }

    @Override
    @KitEvent
    public void onKitPlayerShootBow(EntityShootBowEvent event, KitPlayer kitPlayer, Entity projectile) {
        if (!ChanceUtils.roll((int)this.effectLikelihood)) {
            return;
        }
        if (!(event.getProjectile() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getProjectile();
        PotionEffectType type = this.potionEffectTypes.get(ThreadLocalRandom.current().nextInt(this.potionEffectTypes.size()));
        PotionEffect potionEffect = new PotionEffect(type, this.effectDurationInSeconds * 20, this.effectAmplifier);
        arrow.addCustomEffect(potionEffect, false);
        arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
    }
}

