/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class KitItemBuilder {
    private final ItemStack item;
    private final ItemMeta itemMeta;

    public KitItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.itemMeta = this.item.getItemMeta();
    }

    public KitItemBuilder(ItemStack itemStack) {
        this.item = itemStack;
        this.itemMeta = this.item.getItemMeta();
    }

    public KitItemBuilder setName(String name) {
        this.itemMeta.setDisplayName(name);
        return this;
    }

    public KitItemBuilder setPlayerSkull(String name) {
        SkullMeta skullMeta = (SkullMeta)this.itemMeta;
        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        return this;
    }

    public KitItemBuilder setPlayerSkullSkin(String base64) {
        if (base64.isEmpty()) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.itemMeta;
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        try {
            Method mtd = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            mtd.setAccessible(true);
            mtd.invoke((Object)skullMeta, profile);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public KitItemBuilder setTitle(String name) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.setTitle(name);
        return this;
    }

    public KitItemBuilder addPage(String text) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.addPage(new String[]{text});
        return this;
    }

    public KitItemBuilder setAuthor(String author) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.setAuthor(author);
        return this;
    }

    public KitItemBuilder setPage(int page, String text) {
        BookMeta bookMeta = (BookMeta)this.itemMeta;
        bookMeta.setPage(page, text);
        return this;
    }

    public KitItemBuilder setDescription(String ... lore) {
        this.itemMeta.setLore(Arrays.asList(lore));
        return this;
    }

    public KitItemBuilder addLore(String ... lore) {
        ArrayList<String> text = new ArrayList<String>();
        if (this.itemMeta.getLore() != null) {
            text.addAll(this.itemMeta.getLore());
        }
        text.addAll(Arrays.asList(lore));
        this.itemMeta.setLore(text);
        return this;
    }

    public KitItemBuilder setPotionEffect(PotionEffectType potionEffect, Color color) {
        PotionMeta potionMeta = (PotionMeta)this.itemMeta;
        potionMeta.setColor(color);
        potionMeta.addCustomEffect(new PotionEffect(potionEffect, 0, 0), true);
        return this;
    }

    public KitItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public KitItemBuilder setUnbreakable(boolean unbreakable) {
        this.itemMeta.setUnbreakable(unbreakable);
        return this;
    }

    public KitItemBuilder setEnchantment(Enchantment enchantment, int lvl) {
        this.itemMeta.addEnchant(enchantment, lvl, true);
        return this;
    }

    public KitItemBuilder hideItemFlags() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        return this;
    }

    public KitItemBuilder hideEnchants() {
        this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        return this;
    }

    public KitItemBuilder setLocalizedName(String name) {
        this.itemMeta.setLocalizedName(name);
        return this;
    }

    public ItemStack build() {
        this.addLore(ChatColor.RED + "Kititem");
        this.item.setItemMeta(this.itemMeta);
        return this.item;
    }
}

