/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.events;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.MultipleKitItemsKit;
import de.hglabor.plugins.kitapi.kit.events.KitEventInfo;
import de.hglabor.plugins.kitapi.kit.events.KitEvents;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.supplier.KitPlayerSupplier;
import de.hglabor.plugins.kitapi.util.Logger;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class KitEventHandler
extends KitEvents {
    protected final KitPlayerSupplier playerSupplier;

    public KitEventHandler(KitPlayerSupplier playerSupplier) {
        this.playerSupplier = playerSupplier;
    }

    private static boolean checkBasicKitSettings(Event event, KitPlayer kitPlayer, AbstractKit kit) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return true;
        }
        if (!kit.isEnabled()) {
            return true;
        }
        if (!kit.isUsable()) {
            return true;
        }
        if (!kitPlayer.isValid()) {
            return true;
        }
        Logger.debug(String.format("%s, %s", kit.getName(), event.getEventName()));
        kit.getKitEvents().forEach(kitEventInfo -> Logger.debug(String.format("%s, %s", kit.getName(), kitEventInfo.getEvent().getName())));
        if (kit.getKitEvents().stream().noneMatch(kitEventInfo -> kitEventInfo.getEvent().equals(event.getClass())) && kit.getKitEvents().stream().noneMatch(kitEvent -> event.getClass().getSuperclass().equals(kitEvent.getEvent()))) {
            Logger.debug(String.format("%s, %s \u00a74DIDNT FIT", kit.getName(), event.getEventName()));
            return true;
        }
        if (!kitPlayer.hasKit(kit)) {
            Logger.debug(String.format("%s no kit %s", player.getName(), kit.getName()));
            return true;
        }
        if (kitPlayer.areKitsDisabled()) {
            player.sendActionBar(Localization.INSTANCE.getMessage("kit.disabled", ChatUtils.locale((Player)player)));
            return true;
        }
        Logger.debug(String.format("%s, %s \u00a7aSUCCESSFULL - CHECK BASIC", kit.getName(), event.getEventName()));
        return false;
    }

    public static boolean canUseKit(Event event, KitPlayer kitPlayer, AbstractKit kit) {
        if (KitEventHandler.checkBasicKitSettings(event, kitPlayer, kit)) {
            return false;
        }
        KitEventInfo kitEventInfo = kit.getKitEvents().stream().filter(info -> info.getEvent().equals(event.getClass())).findFirst().orElse(null);
        if (kitEventInfo != null ? !kitEventInfo.isIgnoreCooldown() && KitApi.getInstance().sendCooldownMessage(kitPlayer, kit) : KitApi.getInstance().sendCooldownMessage(kitPlayer, kit)) {
            return false;
        }
        Logger.debug(String.format("%s, %s \u00a7aSUCCESSFULL", kit.getName(), event.getEventName()));
        return true;
    }

    public static boolean canUseKitItem(Event event, KitPlayer kitPlayer, AbstractKit kit) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return false;
        }
        Logger.debug(String.format("Kit %s, Player %s, Event %s", kit.getName(), player.getName(), event.getEventName()));
        if (kit.getMainKitItem() == null) {
            Logger.debug(String.format("Kit %s, Player %s, Event %s \u00a74NO KIT ITEM", kit.getName(), player.getName(), event.getEventName()));
            return false;
        }
        if (!KitApi.getInstance().hasKitItemInAnyHand(player, kit)) {
            Logger.debug(String.format("Kit %s, Player %s, Event %s \u00a74NO KIT ITEM IN HAND", kit.getName(), player.getName(), event.getEventName()));
            return false;
        }
        return KitEventHandler.canUseKit(event, kitPlayer, kit);
    }

    public static boolean canUseOneOfMultipleKitItems(Event event, KitPlayer kitPlayer, MultipleKitItemsKit kit, ItemStack itemStack) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        Logger.debug(String.format("Kit %s, Player %s, Event %s", kit.getName(), player.getName(), event.getEventName()));
        if (!kit.isKitItem(itemStack)) {
            Logger.debug(String.format("Kit %s, Player %s, Event %s \u00a74NO KIT ITEM", kit.getName(), player.getName(), event.getEventName()));
            return false;
        }
        if (KitEventHandler.checkBasicKitSettings(event, kitPlayer, kit)) {
            return false;
        }
        return !kit.sendCooldownMessage(kitPlayer, itemStack);
    }
}

