/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.events.KitEventInfo;
import de.hglabor.plugins.kitapi.kit.events.KitEvents;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.BoolArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractKit
extends KitEvents {
    private static final String KIT_ITEM_DESC = ChatColor.RED + "Kititem";
    private final String name;
    private final List<ItemStack> additionalKitItems;
    private final Map<Locale, ItemStack> displayItems;
    private final Set<KitEventInfo> kitEvents;
    protected ItemStack mainKitItem;
    @BoolArg
    private boolean isEnabled = true;
    @BoolArg
    private boolean isUsable = true;
    private boolean usesOffHand;
    private boolean isKitItemPlaceable;

    protected AbstractKit(String name, Material material) {
        this(name, new ItemStack(material));
    }

    protected AbstractKit(String name) {
        this.name = name;
        this.displayItems = new HashMap<Locale, ItemStack>();
        this.kitEvents = new HashSet<KitEventInfo>();
        this.additionalKitItems = new ArrayList<ItemStack>();
    }

    protected AbstractKit(String name, Material material, List<ItemStack> additionalKitItems) {
        this(name, new ItemStack(material));
        this.additionalKitItems.addAll(additionalKitItems);
    }

    protected AbstractKit(String name, ItemStack displayItem) {
        this.name = name;
        this.displayItems = new HashMap<Locale, ItemStack>();
        this.kitEvents = new HashSet<KitEventInfo>();
        this.additionalKitItems = new ArrayList<ItemStack>();
        this.setDisplayItem(displayItem);
    }

    public void onEnable(KitPlayer kitPlayer) {
    }

    public void onDisable(KitPlayer kitPlayer) {
        this.onDeactivation(kitPlayer);
    }

    public void onDeactivation(KitPlayer kitPlayer) {
    }

    public Material getDisplayMaterial() {
        return this.displayItems.get(Locale.ENGLISH).getType();
    }

    public ItemStack getDisplayItem(Locale locale) {
        return this.displayItems.getOrDefault(locale, new ItemStack(Material.AIR));
    }

    protected final void setDisplayItem(ItemStack item) {
        for (Locale supportedLanguage : KitApi.getInstance().getSupportedLanguages()) {
            ArrayList<String> description = new ArrayList<String>(Arrays.asList(Localization.INSTANCE.getMessage(this.name.toLowerCase() + ".description", supportedLanguage).split("#")));
            if (this.getClass().isAnnotationPresent(BetaKit.class)) {
                description.add("");
                description.add(ChatColor.GOLD + "[BETA] Bugs bitte im Discord reporten!");
            }
            this.displayItems.put(supportedLanguage, new ItemBuilder(item.clone()).setName(ChatColor.RED + this.name).setDescription(description.toArray(new String[0])).build());
        }
    }

    public void setMainKitItem(Material material, boolean unbreakable) {
        this.mainKitItem = new ItemBuilder(material).setDescription(new String[]{KIT_ITEM_DESC}).setUnbreakable(unbreakable).build();
    }

    public void setMainKitItem(Material material, int size) {
        this.mainKitItem = new ItemBuilder(material).setDescription(new String[]{KIT_ITEM_DESC}).setAmount(size).build();
    }

    public void setMainKitItem(ItemStack item, int size) {
        this.mainKitItem = new ItemBuilder(item.clone()).setDescription(new String[]{KIT_ITEM_DESC}).setAmount(size).build();
    }

    public ItemStack getMainKitItem() {
        return this.mainKitItem != null ? this.mainKitItem.clone() : null;
    }

    public void setMainKitItem(Material material) {
        this.mainKitItem = material.equals((Object)Material.AIR) ? new ItemStack(Material.AIR) : new ItemBuilder(material).setDescription(new String[]{KIT_ITEM_DESC}).build();
    }

    public void setMainKitItem(ItemStack item) {
        this.mainKitItem = new ItemBuilder(item.clone()).setDescription(new String[]{KIT_ITEM_DESC}).build();
    }

    protected final void addAdditionalKitItems(ItemStack ... itemStack) {
        Collections.addAll(this.additionalKitItems, itemStack);
    }

    public List<ItemStack> getKitItems() {
        ArrayList<ItemStack> kitItems = new ArrayList<ItemStack>();
        if (this.mainKitItem != null) {
            kitItems.add(this.mainKitItem.clone());
        }
        if (!this.additionalKitItems.isEmpty()) {
            this.additionalKitItems.stream().map(ItemStack::clone).forEach(kitItems::add);
        }
        return kitItems;
    }

    public void setUsesOffHand(boolean usesOffHand) {
        this.usesOffHand = usesOffHand;
    }

    public float getCooldown() {
        return 0.0f;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public List<ItemStack> getDisplayItems() {
        return new ArrayList<ItemStack>(this.displayItems.values());
    }

    public boolean isUsingOffHand() {
        return this.usesOffHand;
    }

    public boolean isUsable() {
        return this.isUsable;
    }

    public void setUsable(boolean usable) {
        this.isUsable = usable;
    }

    public Set<KitEventInfo> getKitEvents() {
        return this.kitEvents;
    }

    public boolean isKitItem(ItemStack itemStack) {
        return this.getKitItems().stream().anyMatch(stack -> stack.isSimilar(itemStack));
    }

    public boolean isKitItemPlaceable() {
        return this.isKitItemPlaceable;
    }

    public void setKitItemPlaceable(boolean kitItemPlaceable) {
        this.isKitItemPlaceable = kitItemPlaceable;
    }

    protected List<KitPlayer> getKitPlayersInRadius(Player player, double radius) {
        ArrayList<KitPlayer> enemies = new ArrayList<KitPlayer>();
        for (Player nearbyPlayer : player.getWorld().getNearbyEntitiesByType(Player.class, player.getLocation(), radius)) {
            KitPlayer nearbyKitPlayer = KitApi.getInstance().getPlayer(nearbyPlayer);
            if (!nearbyKitPlayer.isValid()) continue;
            enemies.add(nearbyKitPlayer);
        }
        return enemies;
    }
}

