/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.util.pathfinder;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySmallFireball;

public class LaborPathfinderGoalBlazeFireball
extends PathfinderGoal {
    private final EntityBlaze blaze;
    private int attackStep;
    private int attackTime;
    private int lastSeen;

    public LaborPathfinderGoalBlazeFireball(EntityBlaze blaze) {
        this.blaze = blaze;
        this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
    }

    public boolean a() {
        EntityLiving livingEntity = this.blaze.getGoalTarget();
        return livingEntity != null && livingEntity.isAlive() && this.blaze.c(livingEntity);
    }

    public void c() {
        this.attackStep = 0;
    }

    public void d() {
        this.lastSeen = 0;
    }

    public void e() {
        --this.attackTime;
        EntityLiving livingEntity = this.blaze.getGoalTarget();
        if (livingEntity != null) {
            boolean bl = this.blaze.getEntitySenses().a((Entity)livingEntity);
            this.lastSeen = bl ? 0 : ++this.lastSeen;
            double d = this.blaze.f((Entity)livingEntity);
            if (d < 4.0) {
                if (!bl) {
                    return;
                }
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.blaze.attackEntity((Entity)livingEntity);
                }
                this.blaze.getControllerMove().a(livingEntity.locX(), livingEntity.locY(), livingEntity.locZ(), 1.0);
            } else if (d < this.getFollowDistance() * this.getFollowDistance() && bl) {
                double e = livingEntity.locX() - this.blaze.locX();
                double f = livingEntity.e(0.5) - this.blaze.e(0.5);
                double g = livingEntity.locZ() - this.blaze.locZ();
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        double h = Math.sqrt(Math.sqrt(d)) * 0.5;
                        if (!this.blaze.isSilent()) {
                            this.blaze.t.a((EntityHuman)null, 1018, this.blaze.getChunkCoordinates(), 0);
                        }
                        for (int i = 0; i < 1; ++i) {
                            EntitySmallFireball smallFireball = new EntitySmallFireball(this.blaze.t, (EntityLiving)this.blaze, e + this.blaze.getRandom().nextGaussian() * h, f, g + this.blaze.getRandom().nextGaussian() * h);
                            smallFireball.setPosition(smallFireball.locX(), this.blaze.e(0.5) + 0.5, smallFireball.locZ());
                            this.blaze.t.addEntity((Entity)smallFireball);
                        }
                    }
                }
                this.blaze.getControllerLook().a((Entity)livingEntity, 10.0f, 10.0f);
            } else if (this.lastSeen < 5) {
                this.blaze.getControllerMove().a(livingEntity.locX(), livingEntity.locY(), livingEntity.locZ(), 1.0);
            }
            super.e();
        }
    }

    private double getFollowDistance() {
        return this.blaze.b(GenericAttributes.b);
    }
}

