/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object get(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getRecursive(Field field, Object obj, Field ... superFields) {
        for (Field superField : superFields) {
            obj = ReflectionUtils.get(superField, obj);
        }
        return ReflectionUtils.get(field, obj);
    }

    public static Object getRecursive(Field field, Object obj, Iterable<Field> superFields) {
        for (Field superField : superFields) {
            obj = ReflectionUtils.get(superField, obj);
        }
        return ReflectionUtils.get(field, obj);
    }

    public static byte getByte(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getByte(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static short getShort(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getShort(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getInt(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getInt(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getLong(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getLong(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static float getFloat(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getFloat(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static double getDouble(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getDouble(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean getBool(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getBoolean(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static char getChar(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.getChar(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void set(Field field, Object obj, Object value) {
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setRecursive(Field field, Object obj, Object value, Iterable<Field> superFields) {
        for (Field superField : superFields) {
            obj = ReflectionUtils.get(superField, obj);
        }
        ReflectionUtils.set(field, obj, value);
    }

    public static void setRecursive(Field field, Object obj, Object value, Field ... superFields) {
        for (Field superField : superFields) {
            obj = ReflectionUtils.get(superField, obj);
        }
        ReflectionUtils.set(field, obj, value);
    }

    public static Field getField(Class<?> clazz, String name) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static boolean isByte(Field field) {
        return ReflectionUtils.isByte(field.getType());
    }

    public static boolean isShort(Field field) {
        return ReflectionUtils.isShort(field.getType());
    }

    public static boolean isInt(Field field) {
        return ReflectionUtils.isInt(field.getType());
    }

    public static boolean isLong(Field field) {
        return ReflectionUtils.isLong(field.getType());
    }

    public static boolean isFloat(Field field) {
        return ReflectionUtils.isFloat(field.getType());
    }

    public static boolean isDouble(Field field) {
        return ReflectionUtils.isDouble(field.getType());
    }

    public static boolean isBool(Field field) {
        return ReflectionUtils.isBool(field.getType());
    }

    public static boolean isChar(Field field) {
        return ReflectionUtils.isChar(field.getType());
    }

    public static boolean isMaterial(Field field) {
        return ReflectionUtils.isMaterial(field.getType());
    }

    public static boolean isPotionType(Field field) {
        return ReflectionUtils.isPotionType(field.getType());
    }

    public static boolean isPotionEffect(Field field) {
        return ReflectionUtils.isPotionEffect(field.getType());
    }

    public static boolean isSound(Field field) {
        return ReflectionUtils.isSound(field.getType());
    }

    public static boolean isEntityType(Field field) {
        return ReflectionUtils.isEntityType(field.getType());
    }

    public static boolean isByte(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Byte.class;
    }

    public static boolean isShort(Class<?> clazz) {
        return clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isInt(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class;
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Long.class;
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz == Float.TYPE || clazz == Float.class;
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isBool(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public static boolean isChar(Class<?> clazz) {
        return clazz == Character.TYPE || clazz == Character.class;
    }

    public static boolean isMaterial(Class<?> clazz) {
        return clazz.equals(Material.class);
    }

    public static boolean isPotionType(Class<?> clazz) {
        return clazz.equals(PotionType.class);
    }

    public static boolean isEntityType(Class<?> clazz) {
        return clazz.equals(EntityType.class);
    }

    public static boolean isPotionEffect(Class<?> clazz) {
        return clazz.equals(PotionEffect.class);
    }

    public static boolean isSound(Class<?> clazz) {
        return clazz.equals(Sound.class);
    }
}

