/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.supplier;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.supplier.KitItemSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class KitItemSupplierImpl
implements KitItemSupplier {
    public static final KitItemSupplierImpl INSTANCE = new KitItemSupplierImpl();

    private KitItemSupplierImpl() {
    }

    @Override
    public void giveKitItems(KitPlayer kitPlayer, AbstractKit abstractKit) {
        this.addKitItemsToInventory(kitPlayer, abstractKit);
    }

    @Override
    public void giveKitItems(KitPlayer kitPlayer, AbstractKit abstractKit, List<ItemStack> list) {
        this.addKitItemsToInventory(kitPlayer, abstractKit, list);
    }

    @Override
    public void giveItems(KitPlayer kitPlayer, List<ItemStack> list) {
        this.addItemsToInventory(kitPlayer, list);
    }

    @Override
    public void giveKitItemsDirectly(KitPlayer kitPlayer, AbstractKit kit) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player != null) {
            if (kit.isUsingOffHand()) {
                player.getInventory().setItemInOffHand(kit.getMainKitItem());
            } else {
                kit.getKitItems().forEach(kitItem -> player.getInventory().addItem(new ItemStack[]{kitItem}));
            }
        }
    }

    private void addKitItemsToInventory(final KitPlayer kitPlayer, final AbstractKit kit) {
        final Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return;
        }
        final ArrayList<ItemStack> kitItems = new ArrayList<ItemStack>(kit.getKitItems());
        if (kit.isUsingOffHand()) {
            player.getInventory().setItemInOffHand(kit.getMainKitItem());
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!(kitPlayer.isValid() && player.isValid() && kitPlayer.hasKit(kit))) {
                    this.cancel();
                    return;
                }
                while (player.getInventory().firstEmpty() != -1 && kitItems.size() > 0) {
                    if (!player.getInventory().contains((ItemStack)kitItems.get(0))) {
                        player.getInventory().addItem(new ItemStack[]{(ItemStack)kitItems.get(0)});
                    }
                    kitItems.remove(0);
                }
                if (kitItems.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
    }

    private void addKitItemsToInventory(final KitPlayer kitPlayer, final AbstractKit kit, List<ItemStack> extraItems) {
        final Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return;
        }
        final ArrayList<ItemStack> kitItems = new ArrayList<ItemStack>(kit.getKitItems());
        kitItems.addAll(extraItems);
        if (kit.isUsingOffHand()) {
            player.getInventory().setItemInOffHand(kit.getMainKitItem());
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!(kitPlayer.isValid() && player.isValid() && kitPlayer.hasKit(kit))) {
                    this.cancel();
                    return;
                }
                while (player.getInventory().firstEmpty() != -1 && kitItems.size() > 0) {
                    if (!player.getInventory().contains((ItemStack)kitItems.get(0))) {
                        player.getInventory().addItem(new ItemStack[]{(ItemStack)kitItems.get(0)});
                    }
                    kitItems.remove(0);
                }
                if (kitItems.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
    }

    private void addItemsToInventory(final KitPlayer kitPlayer, List<ItemStack> itemStacks) {
        final Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player == null) {
            return;
        }
        final ArrayList<ItemStack> itemsToGive = new ArrayList<ItemStack>(itemStacks);
        new BukkitRunnable(){

            public void run() {
                if (!player.isValid() || !kitPlayer.isValid()) {
                    this.cancel();
                    return;
                }
                while (player.getInventory().firstEmpty() != -1 && itemsToGive.size() > 0) {
                    player.getInventory().addItem(new ItemStack[]{(ItemStack)itemsToGive.get(0)});
                    itemsToGive.remove(0);
                }
                if (itemsToGive.isEmpty()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
    }
}

