/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.pvp;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.kit.kits.analyst.AnalystKit;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.supplier.IPlayerList;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;

public class Tracker
implements Listener {
    private final double distance;
    private final IPlayerList playerList;

    public Tracker(double distance, IPlayerList playerList) {
        this.distance = distance;
        this.playerList = playerList;
    }

    @EventHandler
    public void onUseTracker(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Entity target = this.searchForCompassTarget(player);
        KitPlayer kitPlayer = this.playerList.getKitPlayer(player);
        if (event.getMaterial() == Material.COMPASS) {
            if (target == null) {
                player.sendMessage(Localization.t((String)"hglabor.tracker.noTarget", (Locale)ChatUtils.locale((Player)player)));
            } else {
                player.setCompassTarget(target.getLocation());
                this.sendTrackingMessage(player, target, kitPlayer);
            }
        }
    }

    private void sendTrackingMessage(Player player, Entity target, KitPlayer kitPlayer) {
        if (kitPlayer.hasKit(AnalystKit.INSTANCE)) {
            KitPlayer targetKitPlayer = this.playerList.getKitPlayer((Player)target);
            player.sendMessage(Localization.t((String)"hglabor.tracker.targetDetailed", (Map)ImmutableMap.of((Object)"targetName", (Object)target.getName(), (Object)"kits", (Object)targetKitPlayer.printKits(), (Object)"distance", (Object)String.valueOf((int)player.getLocation().distance(target.getLocation()))), (Locale)ChatUtils.locale((Player)player)));
        } else {
            player.sendMessage(Localization.t((String)"hglabor.tracker.target", (Map)ImmutableMap.of((Object)"targetName", (Object)target.getName()), (Locale)ChatUtils.locale((Player)player)));
        }
    }

    private Entity searchForCompassTarget(Player tracker) {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Entity possibleTarget : this.playerList.getTrackingTargets()) {
            double distanceBetween;
            if (possibleTarget == null || !tracker.getWorld().equals(possibleTarget.getWorld()) || tracker == possibleTarget || !((distanceBetween = this.getDistanceBetween((Entity)tracker, possibleTarget)) > this.distance)) continue;
            pairs.add(Pair.of((Object)possibleTarget, (Object)distanceBetween));
        }
        Optional<Pair> target = pairs.stream().min(Comparator.comparingDouble(Pair::getRight));
        return target.isEmpty() ? null : (Entity)target.get().getLeft();
    }

    private double getDistanceBetween(Entity player, Entity player2) {
        Location location = player.getLocation().clone();
        Location location2 = player2.getLocation().clone();
        location.setY(0.0);
        location2.setY(0.0);
        return location.distanceSquared(location2);
    }
}

