/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.pvp;

import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkyBorder
implements Listener {
    private final int damage;
    private final JavaPlugin plugin;
    private final int maxHeight;

    public SkyBorder(JavaPlugin plugin, int maxHeight, int damage) {
        this.damage = damage;
        this.plugin = plugin;
        this.maxHeight = maxHeight;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void tick(List<Player> players) {
        for (Player player : players) {
            if (!(player.getLocation().getY() >= (double)this.maxHeight)) continue;
            player.damage((double)this.damage);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getBlockPlaced().getY() >= this.maxHeight) {
            event.getPlayer().sendMessage(Localization.t((String)"skyBorder.limit", (Locale)ChatUtils.locale((Player)event.getPlayer())));
            event.setCancelled(true);
        }
    }

    public int getDamage() {
        return this.damage;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }
}

