/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.player;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.Passive;
import de.hglabor.plugins.kitapi.kit.config.Cooldown;
import de.hglabor.plugins.kitapi.kit.kits.CopyCatKit;
import de.hglabor.plugins.kitapi.kit.passives.NonePassive;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.pvp.LastHitInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class KitPlayerImpl
implements KitPlayer {
    protected final UUID uuid;
    protected final List<AbstractKit> kits;
    protected final Map<String, Object> kitAttributes;
    protected final LastHitInformation lastHitInformation;
    private final List<Long> leftClicks;
    protected Passive passive;
    protected boolean kitsDisabled;
    protected boolean inInventory;

    public KitPlayerImpl(UUID uuid) {
        this.uuid = uuid;
        this.leftClicks = new ArrayList<Long>();
        this.kitAttributes = new HashMap<String, Object>();
        this.lastHitInformation = new LastHitInformation();
        this.kits = KitApi.getInstance().emptyKitList();
        this.passive = NonePassive.INSTANCE;
    }

    @Override
    public List<AbstractKit> getKits() {
        AbstractKit copyCatKit = (AbstractKit)this.getKitAttribute(CopyCatKit.INSTANCE.getKitAttributeKey());
        if (copyCatKit != null) {
            ArrayList<AbstractKit> kitList = new ArrayList<AbstractKit>(this.kits);
            kitList.add(copyCatKit);
            return kitList;
        }
        return this.kits;
    }

    @Override
    public void setKits(List<AbstractKit> list) {
        this.kits.clear();
        this.kits.addAll(list);
    }

    @Override
    public Passive getPassive() {
        return this.passive;
    }

    @Override
    public void setPassive(Passive passive) {
        this.passive = passive;
    }

    @Override
    public boolean hasKit(AbstractKit kit) {
        AbstractKit copyCatKit = (AbstractKit)this.getKitAttribute(CopyCatKit.INSTANCE.getKitAttributeKey());
        return copyCatKit != null && copyCatKit.equals(kit) || this.kits.contains(kit);
    }

    @Override
    public boolean areKitsDisabled() {
        return this.kitsDisabled;
    }

    @Override
    public void setKit(AbstractKit abstractKit, int i) {
        this.kits.set(i, abstractKit);
    }

    @Override
    public LastHitInformation getLastHitInformation() {
        return this.lastHitInformation;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public abstract boolean isValid();

    @Override
    public boolean isInCombat(int combatTimeLimit) {
        Optional<Player> lastDamager = this.lastHitInformation.getLastDamager();
        if (!lastDamager.isPresent()) {
            return false;
        }
        KitPlayer damager = KitApi.getInstance().getPlayer(lastDamager.get());
        return damager.isValid() && this.lastHitInformation.getLastDamagerTimestamp() + (long)combatTimeLimit * 1000L > System.currentTimeMillis();
    }

    @Override
    public void disableKits(boolean kitsDisabled) {
        this.kitsDisabled = kitsDisabled;
        if (kitsDisabled) {
            this.kits.forEach(kit -> kit.onDeactivation(this));
        } else {
            this.kits.forEach(kit -> kit.onEnable(this));
        }
    }

    @Override
    public void activateKitCooldown(AbstractKit kit) {
        if (this.hasKit(kit) && !this.getKitCooldown(kit).hasCooldown()) {
            this.kitAttributes.put(KitApi.getInstance().cooldownKey(kit), new Cooldown(true, kit.getCooldown()));
        }
    }

    @Override
    public void clearCooldown(AbstractKit kit) {
        this.kitAttributes.remove(KitApi.getInstance().cooldownKey(kit));
    }

    @Override
    public Cooldown getKitCooldown(AbstractKit kit) {
        return (Cooldown)this.kitAttributes.getOrDefault(KitApi.getInstance().cooldownKey(kit), new Cooldown(false));
    }

    @Override
    public <T> T getKitAttribute(String key) {
        return (T)this.kitAttributes.get(key);
    }

    @Override
    public <T> T getKitAttributeOrDefault(String key, T defaultValue) {
        return this.getKitAttribute(key) == null ? defaultValue : this.getKitAttribute(key);
    }

    @Override
    public <T> void putKitAttribute(String key, T value) {
        this.kitAttributes.put(key, value);
    }

    @Override
    public boolean isInInventory() {
        return this.inInventory;
    }

    @Override
    public void setInInventory(boolean value) {
        this.inInventory = value;
    }

    @Override
    public Optional<Player> getBukkitPlayer() {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)this.uuid));
    }

    public void resetKitAttributes() {
        this.kitAttributes.clear();
    }

    @Override
    public String printKits() {
        StringBuilder stringBuilder = new StringBuilder();
        this.kits.forEach(kit -> stringBuilder.append(kit.getName()).append(","));
        stringBuilder.delete(stringBuilder.lastIndexOf(","), stringBuilder.length());
        return stringBuilder.toString();
    }

    @Override
    public int getLeftCps() {
        long time = System.currentTimeMillis();
        this.leftClicks.removeIf(value -> value + 1000L < time);
        return this.leftClicks.size();
    }

    @Override
    public void addLeftClick(long value) {
        this.leftClicks.add(value);
    }
}

