/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits.analyst;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.kits.analyst.AnalystHologram;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class AnalystKit
extends AbstractKit
implements Listener {
    public static final AnalystKit INSTANCE = new AnalystKit();
    @FloatArg
    public final float cooldown;
    @IntArg
    private final int hologramKeepAlive;
    private final Set<Integer> hologramIds;
    private final String hologramKey;

    private AnalystKit() {
        super("Analyst", Material.GLASS_PANE);
        this.setMainKitItem(this.getDisplayMaterial());
        this.hologramIds = new HashSet<Integer>();
        this.hologramKeepAlive = 10;
        this.cooldown = 60.0f;
        this.hologramKey = this.getName() + "key";
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        List holograms = kitPlayer.getKitAttributeOrDefault(this.hologramKey, new ArrayList());
        for (AnalystHologram hologram : holograms) {
            this.hologramIds.removeIf(integer -> integer.intValue() == hologram.getId());
            hologram.die(DamageSource.n);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.hologramIds.forEach(hologramId -> ((CraftPlayer)player).getHandle().b.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{hologramId})));
    }

    @Override
    @KitEvent
    public void onPlayerRightClickPlayerWithKitItem(PlayerInteractAtEntityEvent event, KitPlayer kitPlayer, Player rightClicked) {
        Player player = event.getPlayer();
        double boost = 0.25;
        ArrayList<AnalystHologram> analystHolograms = new ArrayList<AnalystHologram>();
        for (AnalystHologram.HologramType type : AnalystHologram.HologramType.values()) {
            World world = rightClicked.getWorld();
            AnalystHologram analystHologram = new AnalystHologram(world, rightClicked, player, type, boost += 0.25);
            analystHolograms.add(analystHologram);
            this.hologramIds.add(analystHologram.getId());
            ((CraftWorld)world).getHandle().addEntity((Entity)analystHologram);
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (onlinePlayer == player) continue;
                ((CraftPlayer)onlinePlayer).getHandle().b.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{analystHologram.getId()}));
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> {
            for (AnalystHologram analystHologram : analystHolograms) {
                this.hologramIds.removeIf(integer -> integer.intValue() == analystHologram.getId());
                analystHologram.die(DamageSource.n);
            }
        }, (long)this.hologramKeepAlive * 20L);
        kitPlayer.putKitAttribute(this.hologramKey, analystHolograms);
        kitPlayer.activateKitCooldown(this);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

