/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits.analyst;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.pvp.recraft.Recraft;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AnalystHologram
extends EntityArmorStand {
    private final Player target;
    private final Player owner;
    private final HologramType type;
    private final double boost;

    public AnalystHologram(org.bukkit.World world, Player target, Player owner, HologramType type, double boost) {
        super(EntityTypes.c, (World)((CraftWorld)world).getHandle());
        this.owner = owner;
        this.type = type;
        this.boost = boost;
        this.target = target;
        this.persist = false;
        this.setCustomNameVisible(true);
        this.setInvisible(true);
        this.setMarker(true);
        this.setSilent(true);
    }

    public void tick() {
        if (!this.valid) {
            return;
        }
        super.tick();
        if (!this.target.isOnline() || this.target.isDead() || !this.target.isValid()) {
            this.die(DamageSource.n);
            return;
        }
        if (!this.owner.isOnline() || this.owner.isDead() || !this.owner.isValid()) {
            this.die(DamageSource.n);
            return;
        }
        this.setCustomName((IChatBaseComponent)new ChatComponentText(this.getInformation()));
        Location location = this.target.getEyeLocation().clone();
        this.setPosition(location.getX(), location.getY() + this.boost, location.getZ());
    }

    private String getInformation() {
        switch (this.type) {
            case SOUPS: {
                return "Soups: " + this.getMaterialAmount(Material.MUSHROOM_STEW);
            }
            case RECRAFT: {
                Recraft recraft = new Recraft();
                recraft.calcRecraft(this.target.getInventory().getContents());
                return String.format("Recraft: %sx", Float.valueOf(recraft.getRecraftPoints()));
            }
            case CPS: {
                KitPlayer player = KitApi.getInstance().getPlayer(this.target);
                return String.format("CPS: %s", player.getLeftCps());
            }
        }
        return "";
    }

    public int getMaterialAmount(Material material) {
        return this.target.getInventory().all(material).values().stream().mapToInt(ItemStack::getAmount).sum();
    }

    static enum HologramType {
        SOUPS,
        RECRAFT,
        CPS;

    }
}

