/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class TurtleKit
extends AbstractKit {
    public static final TurtleKit INSTANCE = new TurtleKit();
    @DoubleArg(min=0.1)
    private final double dealingDamage;
    @DoubleArg(min=0.1)
    private final double damageTrigger;
    @DoubleArg(min=0.1)
    private final double damageReplacement;

    private TurtleKit() {
        super("Turtle", Material.TURTLE_HELMET);
        this.dealingDamage = 0.5;
        this.damageTrigger = 0.5;
        this.damageReplacement = 0.5;
    }

    @Override
    @KitEvent
    public void onEntityDamage(EntityDamageEvent event) {
        Player player = (Player)event.getEntity();
        if (event.getDamage() > this.damageTrigger && player.isSneaking()) {
            event.setDamage(this.damageReplacement);
        }
    }

    @Override
    @KitEvent
    public void onPlayerAttacksLivingEntity(EntityDamageByEntityEvent event, KitPlayer attacker, LivingEntity entity) {
        attacker.getBukkitPlayer().ifPresent(player -> {
            if (player.isSneaking()) {
                event.setDamage(this.dealingDamage);
            }
        });
    }
}

