/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ThorKit
extends AbstractKit
implements Listener {
    public static final ThorKit INSTANCE = new ThorKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private final int netherrackHeight;
    @IntArg
    private final int amountOfLightnings;
    @FloatArg
    private final float netherrackPower;
    private final String thorBlockKey = this.getName() + "thorBlock";

    private ThorKit() {
        super("Thor", Material.WOODEN_AXE);
        this.cooldown = 10.0f;
        this.netherrackHeight = 80;
        this.netherrackPower = 4.0f;
        this.amountOfLightnings = 1;
        this.setMainKitItem(this.getDisplayMaterial(), true);
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Location location = event.getClickedBlock().getLocation();
        World world = location.getWorld();
        Location highestBlockLocation = world.getHighestBlockAt(location).getLocation();
        Block highestBlock = highestBlockLocation.getBlock();
        boolean ifExploded = false;
        if (!world.isClearWeather()) {
            world.strikeLightning(highestBlockLocation.add(1.0, 0.0, 0.0));
            world.strikeLightning(highestBlockLocation.add(0.0, 0.0, 1.0));
            world.strikeLightning(highestBlockLocation.add(1.0, 0.0, 1.0));
        } else {
            IntStream.range(0, this.amountOfLightnings).mapToObj(i -> highestBlockLocation).forEach(arg_0 -> ((World)world).strikeLightning(arg_0));
        }
        if (highestBlockLocation.getBlockY() > this.netherrackHeight) {
            if (highestBlock.getType() == Material.NETHERRACK && highestBlock.hasMetadata(this.thorBlockKey)) {
                highestBlock.setType(Material.AIR);
                ifExploded = true;
            } else {
                Block block = highestBlockLocation.add(0.0, 1.0, 0.0).getBlock();
                block.setType(Material.NETHERRACK);
                block.setMetadata(this.thorBlockKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            }
        }
        if (!ifExploded) {
            world.getHighestBlockAt(location).getLocation().add(0.0, 1.0, 0.0).getBlock().setType(Material.FIRE);
        } else {
            highestBlock.getLocation().getWorld().createExplosion(highestBlockLocation, this.netherrackPower, true, true, (Entity)event.getPlayer());
        }
        kitPlayer.activateKitCooldown(this);
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        event.blockList().stream().filter(block -> block.getType() == Material.NETHERRACK).forEach(block -> {
            if (block.getY() > this.netherrackHeight && block.hasMetadata(this.thorBlockKey)) {
                block.setType(Material.AIR);
                block.getLocation().getWorld().createExplosion(block.getLocation(), this.netherrackPower, true, true, (Entity)player);
            }
        });
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

