/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;

public class TankKit
extends AbstractKit {
    public static final TankKit INSTANCE = new TankKit();
    @FloatArg(min=0.1f, max=100.0f)
    private final float explosionSizePlayer;
    @FloatArg(min=0.1f, max=100.0f)
    private final float explosionSizeEntity;
    @FloatArg(min=0.1f, max=100.0f)
    private final float explosionSizeRecraft;

    private TankKit() {
        super("Tank", Material.TNT);
        this.explosionSizePlayer = 6.0f;
        this.explosionSizeEntity = 3.0f;
        this.explosionSizeRecraft = 1.0f;
    }

    @Override
    @KitEvent
    public void onPlayerKillsLivingEntity(EntityDeathEvent event, Player killer, Entity entity) {
        float explosionSize = entity instanceof Player ? this.explosionSizePlayer : this.explosionSizeEntity;
        entity.getWorld().createExplosion(entity.getLocation(), explosionSize, false, true, (Entity)killer);
    }

    @Override
    @KitEvent(clazz=EntityDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        Player deadPlayer = Bukkit.getPlayer((UUID)dead.getUUID());
        Player killerPlayer = Bukkit.getPlayer((UUID)killer.getUUID());
        if (deadPlayer != null) {
            deadPlayer.getWorld().createExplosion(deadPlayer.getLocation(), this.explosionSizePlayer, false, true, (Entity)killerPlayer);
        }
    }

    @Override
    @KitEvent
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            event.setCancelled(true);
        }
    }

    @Override
    @KitEvent
    public void onCraftItem(CraftItemEvent event) {
        Player player = (Player)event.getInventory().getViewers().get(0);
        if (!event.getRecipe().getResult().getType().equals((Object)Material.MUSHROOM_STEW)) {
            return;
        }
        if (event.getClick() != ClickType.SHIFT_LEFT && event.getClick() != ClickType.SHIFT_RIGHT) {
            return;
        }
        if (player.getInventory().firstEmpty() != -1) {
            player.getWorld().createExplosion(player.getLocation(), this.explosionSizeRecraft, false, true, (Entity)player);
        }
    }
}

