/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.LongArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.EulerAngle;

public class SwordmanKit
extends AbstractKit {
    public static final SwordmanKit INSTANCE = new SwordmanKit();
    private final String runnableAttributeKey;
    private final String armorStandAttributeKey;
    @FloatArg(min=0.0f)
    private final float cooldown;
    @LongArg
    private final long animationSpeed;
    @IntArg
    private int radius;
    @IntArg
    private int radiusY;
    @IntArg
    private int effectMultiplier;
    @DoubleArg
    private double damage;
    @IntArg
    private int duration;

    protected SwordmanKit() {
        super("Swordman", Material.GOLDEN_SWORD);
        this.setMainKitItem(new ItemBuilder(this.getDisplayMaterial()).setUnbreakable(true).build());
        this.runnableAttributeKey = "swordmanRunnable";
        this.armorStandAttributeKey = "swordmanArmorStand";
        this.damage = 6.0;
        this.radius = 15;
        this.radiusY = 15;
        this.cooldown = 13.0f;
        this.animationSpeed = 3L;
        this.effectMultiplier = 3;
        this.duration = 6;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        if (kitPlayer.getKitAttribute(this.armorStandAttributeKey) != null) {
            ArmorStand armorStand = (ArmorStand)kitPlayer.getKitAttribute(this.armorStandAttributeKey);
            armorStand.remove();
            BukkitTask bukkitTask = (BukkitTask)kitPlayer.getKitAttribute(this.runnableAttributeKey);
            if (bukkitTask != null) {
                bukkitTask.cancel();
            }
        }
        Entity entity = null;
        for (Entity entities : player.getNearbyEntities((double)this.radius, (double)this.radiusY, (double)this.radius)) {
            KitPlayer targetPlayer;
            if (!(entities instanceof LivingEntity) || entities instanceof ArmorStand || entities instanceof Player && !(targetPlayer = KitApi.getInstance().getPlayer((Player)entities)).isValid()) continue;
            entity = entities;
            break;
        }
        if (entity == null) {
            return;
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 50, this.effectMultiplier, false, false));
        long activationTime = System.currentTimeMillis();
        LivingEntity finalEntity = (LivingEntity)entity;
        ArmorStand armorStand = this.spawnSword(player.getLocation());
        kitPlayer.putKitAttribute(this.armorStandAttributeKey, armorStand);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), () -> {
            BukkitTask bukkitTask = (BukkitTask)kitPlayer.getKitAttribute(this.runnableAttributeKey);
            if ((double)System.currentTimeMillis() >= (double)activationTime + (double)this.duration * 1000.0) {
                armorStand.remove();
                if (bukkitTask != null) {
                    bukkitTask.cancel();
                }
            }
            if (finalEntity.isDead()) {
                armorStand.remove();
                if (bukkitTask != null) {
                    bukkitTask.cancel();
                }
            } else {
                if (armorStand.getLocation().distance(finalEntity.getLocation()) < 2.5) {
                    this.drawParticleCircle(finalEntity.getLocation(), 1.5);
                    finalEntity.getWorld().spawnParticle(Particle.SWEEP_ATTACK, finalEntity.getLocation().clone().add(0.0, 1.4, 0.0), 1);
                    finalEntity.getWorld().playSound(finalEntity.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
                    finalEntity.damage(this.damage, (Entity)player);
                } else {
                    int x = finalEntity.getLocation().getBlockX();
                    int y = finalEntity.getLocation().getBlockY();
                    int z = finalEntity.getLocation().getBlockZ();
                    Location armorStandLocation = armorStand.getLocation().clone();
                    if (armorStandLocation.getBlockX() > x) {
                        armorStandLocation.subtract(0.7, 0.0, 0.0);
                    } else {
                        armorStandLocation.add(0.7, 0.0, 0.0);
                    }
                    if (armorStandLocation.getBlockY() > y) {
                        armorStandLocation.subtract(0.0, 0.7, 0.0);
                    } else {
                        armorStandLocation.add(0.0, 0.7, 0.0);
                    }
                    if (armorStandLocation.getBlockZ() > z) {
                        armorStandLocation.subtract(0.0, 0.0, 0.7);
                    } else {
                        armorStandLocation.add(0.0, 0.0, 0.7);
                    }
                    armorStand.teleport(armorStandLocation);
                }
                armorStand.setRightArmPose(new EulerAngle((double)new Random().nextInt(270), (double)new Random().nextInt(270), (double)new Random().nextInt(270)));
            }
        }, 3L, this.animationSpeed);
        kitPlayer.putKitAttribute(this.runnableAttributeKey, task);
        kitPlayer.activateKitCooldown(this);
    }

    private void drawParticleCircle(Location location, double yOffset) {
        Location loc = location.clone();
        loc.add(0.0, yOffset, 0.0);
        int i = 0;
        while ((long)i < this.animationSpeed * 4L) {
            location.getWorld().spawnParticle(Particle.BLOCK_CRACK, new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ()), 2, (Object)Bukkit.createBlockData((Material)Material.REDSTONE_BLOCK));
            ++i;
        }
    }

    private ArmorStand spawnSword(Location location) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        armorStand.setInvulnerable(true);
        armorStand.setVisible(false);
        armorStand.getEquipment().setItemInMainHand(new ItemBuilder(this.getMainKitItem()).setEnchantment(Enchantment.IMPALING, 1).build());
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            armorStand.addEquipmentLock(equipmentSlot, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(equipmentSlot, ArmorStand.LockType.REMOVING_OR_CHANGING);
        }
        armorStand.setRightArmPose(new EulerAngle(90.0, 90.0, 90.0));
        return armorStand;
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        ArmorStand armorStand;
        BukkitTask task = (BukkitTask)kitPlayer.getKitAttribute(this.runnableAttributeKey);
        if (task != null) {
            task.cancel();
        }
        if ((armorStand = (ArmorStand)kitPlayer.getKitAttribute(this.armorStandAttributeKey)) != null) {
            armorStand.remove();
        }
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        ArmorStand armorStand;
        BukkitTask task = (BukkitTask)kitPlayer.getKitAttribute(this.runnableAttributeKey);
        if (task != null) {
            task.cancel();
        }
        if ((armorStand = (ArmorStand)kitPlayer.getKitAttribute(this.armorStandAttributeKey)) != null) {
            armorStand.remove();
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

