/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class StomperKit
extends AbstractKit {
    public static final StomperKit INSTANCE = new StomperKit();
    @DoubleArg
    private final double radius;

    protected StomperKit() {
        super("Stomper", Material.DIAMOND_BOOTS);
        this.radius = 3.0;
    }

    @Override
    @KitEvent
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
                return;
            }
            Player stomper = (Player)event.getEntity();
            double STOMPER_DAMAGE = event.getDamage();
            stomper.playSound(stomper.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            if (STOMPER_DAMAGE > 4.0) {
                event.setDamage(4.0);
            }
            for (LivingEntity livingEntity : stomper.getWorld().getNearbyEntitiesByType(LivingEntity.class, stomper.getLocation(), this.radius)) {
                if (livingEntity == stomper) continue;
                if (livingEntity instanceof Player) {
                    Player playerEntity = (Player)livingEntity;
                    KitPlayer kitPlayer = KitApi.getInstance().getPlayer(playerEntity);
                    if (!kitPlayer.isValid()) continue;
                    if (!playerEntity.isSneaking()) {
                        livingEntity.damage(STOMPER_DAMAGE, (Entity)stomper);
                    }
                    kitPlayer.getLastHitInformation().setLastDamager(stomper);
                    kitPlayer.getLastHitInformation().setLastDamagerTimestamp(System.currentTimeMillis());
                    playerEntity.playSound(playerEntity.getLocation(), Sound.BLOCK_ANVIL_PLACE, 0.05f, 1.0f);
                    continue;
                }
                livingEntity.damage(STOMPER_DAMAGE, (Entity)stomper);
            }
        }
    }
}

