/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Squid;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SquidKit
extends AbstractKit {
    public static final SquidKit INSTANCE = new SquidKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @DoubleArg
    private final double radius;
    @IntArg
    private final int blindnessDuration;
    @IntArg
    private final int blindnessAmplifier;

    private SquidKit() {
        super("Squid", Material.SQUID_SPAWN_EGG);
        this.cooldown = 13.0f;
        this.radius = 5.0;
        this.blindnessDuration = 3;
        this.blindnessAmplifier = 3;
    }

    @Override
    @KitEvent
    public void onPlayerIsSneakingEvent(PlayerToggleSneakEvent event, KitPlayer kitPlayer) {
        if (!event.isSneaking()) {
            return;
        }
        Player player = event.getPlayer();
        int counter = 0;
        for (KitPlayer enemyKitPlayer : this.getKitPlayersInRadius(player, this.radius)) {
            Player nearbyPlayer = Bukkit.getPlayer((UUID)enemyKitPlayer.getUUID());
            if (nearbyPlayer == player || nearbyPlayer == null || !enemyKitPlayer.isValid()) continue;
            ++counter;
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20 * this.blindnessDuration, this.blindnessAmplifier));
            Squid squid = (Squid)nearbyPlayer.getWorld().spawnEntity(nearbyPlayer.getEyeLocation(), EntityType.SQUID);
            Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> ((Squid)squid).remove(), 40L);
        }
        if (counter > 0) {
            kitPlayer.activateKitCooldown(this);
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

