/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.MaterialArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.CircleUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class SpidermanKit
extends AbstractKit
implements Listener {
    public static final SpidermanKit INSTANCE = new SpidermanKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private final int spidernetRadius;
    @IntArg
    private final int spidernetHeight;
    @MaterialArg
    private final Material spidernetBlock = Material.COBWEB;
    @DoubleArg
    private final double climbVelocity;
    @DoubleArg
    private final double shootingVelocity;
    private final String spidermanSnowballKey = this.getName() + "spidermanSnowball";

    private SpidermanKit() {
        super("Spiderman", Material.COBWEB);
        this.cooldown = 45.0f;
        this.spidernetRadius = 5;
        this.spidernetHeight = 5;
        this.climbVelocity = 0.3;
        this.shootingVelocity = 1.5;
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        kitPlayer.activateKitCooldown(this);
        Vector direction = player.getEyeLocation().getDirection();
        Snowball snowball = (Snowball)player.getWorld().spawn(player.getEyeLocation().add(direction.multiply(this.shootingVelocity)), Snowball.class);
        snowball.setVelocity(direction);
        snowball.setShooter((ProjectileSource)player);
        snowball.setMetadata(this.spidermanSnowballKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{snowball.getEntityId()});
            ((CraftPlayer)p).getHandle().b.sendPacket((Packet)packet);
        }
        FallingBlock cobWeb = player.getWorld().spawnFallingBlock(player.getEyeLocation().add(direction), this.spidernetBlock.createBlockData());
        cobWeb.setHurtEntities(true);
        cobWeb.setVelocity(direction);
        cobWeb.setDropItem(false);
        snowball.addPassenger((Entity)cobWeb);
    }

    @EventHandler
    public void onProjectileHitEvent(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Snowball)) {
            return;
        }
        if (!event.getEntity().hasMetadata(this.spidermanSnowballKey)) {
            return;
        }
        Snowball snowball = (Snowball)event.getEntity();
        Set<Object> spiderNet = new HashSet();
        if (event.getHitEntity() != null) {
            Entity hittedEntity = event.getHitEntity();
            spiderNet = this.createSpiderNet(hittedEntity.getLocation(), this.spidernetRadius, this.spidernetHeight);
        }
        if (event.getHitBlock() != null) {
            Block hittedBlock = event.getHitBlock();
            spiderNet = this.createSpiderNet(hittedBlock.getLocation(), this.spidernetRadius, this.spidernetHeight);
        }
        HashSet finalSpiderNet = spiderNet;
        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> {
            for (Block block : finalSpiderNet) {
                if (!block.getType().equals((Object)this.spidernetBlock)) continue;
                block.setType(Material.AIR);
            }
        }, 200L);
        snowball.remove();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (!kitPlayer.hasKit(this) || !KitApi.getInstance().hasKitItemInAnyHand(player, this) || kitPlayer.areKitsDisabled()) {
            return;
        }
        if (this.nearWall(0.5, event.getPlayer())) {
            if (kitPlayer.getKitCooldown(this).hasCooldown()) {
                player.sendActionBar(Localization.INSTANCE.getMessage("spiderman.noClimbWithCooldown", ChatUtils.locale((Player)player)));
                return;
            }
            player.setVelocity(new Vector(0.0, this.climbVelocity, 0.0));
        }
    }

    public boolean nearWall(double distance, Player player) {
        Vector locale = player.getLocation().toVector();
        int y = locale.getBlockY() + 1;
        double x = locale.getX();
        double z = locale.getZ();
        World world = player.getWorld();
        Block b1 = world.getBlockAt(new Location(world, x + distance, (double)y, z));
        Block b2 = world.getBlockAt(new Location(world, x - distance, (double)y, z));
        Block b3 = world.getBlockAt(new Location(world, x, (double)y, z + distance));
        Block b4 = world.getBlockAt(new Location(world, x, (double)y, z - distance));
        return b1.getType().isSolid() || b2.getType().isSolid() || b3.getType().isSolid() || b4.getType().isSolid();
    }

    private Set<Block> createSpiderNet(Location startLocation, int radius, int height) {
        HashSet<Block> result = new HashSet<Block>();
        for (Location location : CircleUtils.makeCircle((Location)startLocation, (Integer)radius, (Integer)height, (Boolean)true, (Boolean)true, (int)0)) {
            if (!location.getBlock().getType().equals((Object)Material.AIR)) continue;
            result.add(location.getBlock());
            location.getBlock().setType(this.spidernetBlock);
        }
        return result;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

