/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionEffectArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionTypeArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class SmogmogKit
extends AbstractKit
implements Listener {
    public static final SmogmogKit INSTANCE = new SmogmogKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @FloatArg(min=0.0f)
    private final float radius;
    @IntArg
    private final int effectDuration;
    @PotionTypeArg
    private final PotionType potionType = PotionType.INSTANT_DAMAGE;
    @PotionEffectArg
    private final PotionEffectType extraPotionEffectType = PotionEffectType.BLINDNESS;

    private SmogmogKit() {
        super("Smogmog", Material.POPPED_CHORUS_FRUIT);
        this.cooldown = 20.0f;
        this.radius = 8.0f;
        this.effectDuration = 3;
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent e, KitPlayer kitPlayer) {
        Player player = e.getPlayer();
        AreaEffectCloud cloud = (AreaEffectCloud)player.getWorld().spawnEntity(player.getLocation(), EntityType.AREA_EFFECT_CLOUD);
        cloud.setCustomName(player.getUniqueId().toString());
        cloud.setColor(Color.fromBGR((int)new Random().nextInt(255), (int)new Random().nextInt(255), (int)new Random().nextInt(255)));
        cloud.setDuration(this.effectDuration * 20);
        cloud.setSource((ProjectileSource)player);
        cloud.setRadius(this.radius);
        cloud.setBasePotionData(new PotionData(this.potionType, false, false));
        cloud.setRadius(this.radius);
        kitPlayer.activateKitCooldown(this);
        player.getLocation().getWorld().playSound(player.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_CURE, 0.2f, 0.0f);
    }

    @EventHandler
    public void onAreaEffectCloudDamage(EntityDamageByEntityEvent e) {
        if (e.getEntity() instanceof Player && e.getDamager() instanceof AreaEffectCloud) {
            Player involved = (Player)e.getEntity();
            AreaEffectCloud cloud = (AreaEffectCloud)e.getDamager();
            if (involved.getUniqueId().toString().equals(cloud.getCustomName())) {
                e.setCancelled(true);
            } else {
                involved.addPotionEffect(new PotionEffect(this.extraPotionEffectType, this.effectDuration * 20, 0));
            }
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

