/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.kit.settings.PotionEffectArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.TimeConverter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class ScoutKit
extends AbstractKit {
    public static final ScoutKit INSTANCE = new ScoutKit();
    @PotionEffectArg
    private final PotionEffectType potionEffectType;
    @IntArg
    private final int duration;
    @IntArg
    private final int amplifier;
    @IntArg
    private final int potionAmount;
    @IntArg
    private final int supplyInterval;
    private final String runnableKey;
    private final String timeLeftKey;

    private ScoutKit() {
        super("Scout", Material.POTION);
        this.setKitItemPlaceable(true);
        this.potionEffectType = PotionEffectType.SPEED;
        this.duration = 67;
        this.amplifier = 1;
        this.potionAmount = 2;
        this.supplyInterval = 300;
        this.runnableKey = this.getName() + "runnableKey";
        this.timeLeftKey = this.getName() + "timeLeft";
        this.setMainKitItem(this.createScoutPotion(), this.potionAmount);
        this.setDisplayItem(this.createScoutPotion());
    }

    @Override
    @KitEvent
    public void onEntityDamage(EntityDamageEvent event) {
        Player player = (Player)event.getEntity();
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
            return;
        }
        if (player.hasPotionEffect(PotionEffectType.SPEED) && event.getFinalDamage() > 4.0) {
            event.setDamage(4.0);
        }
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        PotionSupplierTask potionSupplierTask = new PotionSupplierTask(kitPlayer);
        kitPlayer.putKitAttribute(this.runnableKey, potionSupplierTask);
        int timeTilNextPotion = kitPlayer.getKitAttributeOrDefault(this.timeLeftKey, this.supplyInterval);
        Localization.INSTANCE.getMessage("scout.nextSupplyIn", (Map)ImmutableMap.of((Object)"time", (Object)TimeConverter.stringify((int)(timeTilNextPotion * 20))), ChatUtils.locale((UUID)kitPlayer.getUUID()));
        potionSupplierTask.runTaskLater((Plugin)KitApi.getInstance().getPlugin(), (long)timeTilNextPotion * 20L);
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        PotionSupplierTask potionSupplierTask = (PotionSupplierTask)((Object)kitPlayer.getKitAttribute(this.runnableKey));
        potionSupplierTask.cancel();
        long timeLeft = System.currentTimeMillis() / 1000L - potionSupplierTask.startTime / 1000L;
        kitPlayer.putKitAttribute(this.timeLeftKey, (int)((long)kitPlayer.getKitAttributeOrDefault(this.timeLeftKey, this.supplyInterval).intValue() - timeLeft));
    }

    private ItemStack createScoutPotion() {
        ItemStack potion = new ItemStack(Material.SPLASH_POTION);
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        meta.addCustomEffect(new PotionEffect(this.potionEffectType, this.duration * 20, this.amplifier), true);
        meta.setDisplayName(ChatColor.AQUA + "Scout Potion");
        meta.setColor(Color.AQUA);
        potion.setItemMeta((ItemMeta)meta);
        return potion;
    }

    private class PotionSupplierTask
    extends BukkitRunnable {
        private final KitPlayer kitPlayer;
        private final long startTime;

        PotionSupplierTask(KitPlayer kitPlayer) {
            this.kitPlayer = kitPlayer;
            this.startTime = System.currentTimeMillis();
        }

        public void run() {
            if (this.isCancelled()) {
                return;
            }
            List<ItemStack> potions = IntStream.rangeClosed(0, ScoutKit.this.potionAmount).mapToObj(i -> ScoutKit.this.createScoutPotion()).collect(Collectors.toList());
            Localization.INSTANCE.getMessage("scout.newPotions", (Map)ImmutableMap.of((Object)"amount", (Object)String.valueOf(ScoutKit.this.potionAmount)), ChatUtils.locale((UUID)this.kitPlayer.getUUID()));
            KitApi.getInstance().giveKitItemsIfInvFull(this.kitPlayer, INSTANCE, potions);
            this.kitPlayer.putKitAttribute(ScoutKit.this.timeLeftKey, ScoutKit.this.supplyInterval);
            ScoutKit.this.onEnable(this.kitPlayer);
        }
    }
}

