/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.RotationUtils;
import de.hglabor.plugins.kitapi.util.Utils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.EulerAngle;

public class ScientistKit
extends AbstractKit
implements Listener {
    public static final ScientistKit INSTANCE = new ScientistKit();
    private static final ArrayList<ArmorStand> TURRETS = new ArrayList();
    private static final String remainingTurretsKey = "remainingTurrets";
    @IntArg
    private final int turretAmount;
    @IntArg
    private final int shotDelay;
    @IntArg
    private final int radius;
    private final ItemStack skull = new KitItemBuilder(Material.PLAYER_HEAD).setPlayerSkullSkin("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmEyYzNlNzlkNWYzNWE5ZGNhYjE5ZTQzYzNlM2E2NTE5ZTQyNmI2NGE2MTIxM2NkMmYxZDI4YjU3MDM2ZjYifX19").build();
    @FloatArg
    private final float shotDamage;

    private ScientistKit() {
        super("Scientist");
        this.setDisplayItem(this.skull);
        this.setMainKitItem(this.skull);
        this.turretAmount = 3;
        this.shotDelay = 40;
        this.shotDamage = 2.0f;
        this.radius = 15;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute(remainingTurretsKey, this.turretAmount);
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(it -> {
            for (ArmorStand turret : Utils.cloneList(TURRETS)) {
                for (String tag : turret.getScoreboardTags()) {
                    if (!tag.equalsIgnoreCase("turret#" + kitPlayer.getName())) continue;
                    TURRETS.remove(turret);
                    turret.remove();
                }
            }
        });
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        kitPlayer.getBukkitPlayer().ifPresent(it -> {
            for (ArmorStand turret : Utils.cloneList(TURRETS)) {
                for (String tag : turret.getScoreboardTags()) {
                    if (!tag.equalsIgnoreCase("turret#" + kitPlayer.getName())) continue;
                    TURRETS.remove(turret);
                    turret.remove();
                }
            }
        });
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Block block;
        Player player = event.getPlayer();
        Integer remainingTurrets = (Integer)kitPlayer.getKitAttribute(remainingTurretsKey);
        if (remainingTurrets != null && remainingTurrets > 0 && event.getAction() == Action.RIGHT_CLICK_BLOCK && (block = event.getClickedBlock()) != null) {
            ArmorStand turret = (ArmorStand)block.getWorld().spawn(block.getLocation().clone().add(0.0, 1.0, 0.0), ArmorStand.class);
            turret.setSmall(true);
            turret.setArms(true);
            turret.getEquipment().setHelmet(this.skull);
            turret.getEquipment().setChestplate(new ItemBuilder(Material.IRON_CHESTPLATE).build());
            turret.getEquipment().setLeggings(new ItemBuilder(Material.IRON_LEGGINGS).build());
            turret.getEquipment().setBoots(new ItemBuilder(Material.NETHERITE_BOOTS).build());
            turret.setItem(EquipmentSlot.OFF_HAND, new ItemStack(Material.BOW));
            for (ArmorStand.LockType lockType : ArmorStand.LockType.values()) {
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    turret.addEquipmentLock(equipmentSlot, lockType);
                }
            }
            turret.addScoreboardTag("turret#" + player.getName());
            turret.setLeftArmPose(new EulerAngle(-30.0, 330.0, 0.0));
            TURRETS.add(turret);
            remainingTurrets = remainingTurrets - 1;
            kitPlayer.putKitAttribute(remainingTurretsKey, remainingTurrets);
            AtomicInteger tick = new AtomicInteger();
            Bukkit.getScheduler().runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), task -> {
                if (turret.isDead()) {
                    TURRETS.remove(turret);
                    task.cancel();
                }
                tick.getAndIncrement();
                for (double i = 0.0; i < 0.5; i += 1.0) {
                    for (double y = 0.0; y < Math.PI * 2; y += 0.1) {
                        double x = (double)this.radius * Math.cos(y);
                        double z = (double)this.radius * Math.sin(y);
                        turret.getWorld().spawnParticle(Particle.REDSTONE, turret.getLocation().clone().add(x, i / 4.0, z), 0, 0.0, 0.0, 0.0, 5.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                    }
                }
                for (Entity nearby : turret.getNearbyEntities((double)this.radius, (double)this.radius, (double)this.radius)) {
                    if (!(nearby instanceof Player) || nearby.getUniqueId() == player.getUniqueId()) continue;
                    RotationUtils.Rotation neededRotation = RotationUtils.getNeededRotations(nearby, (Entity)turret);
                    turret.setRotation(neededRotation.getYaw(), neededRotation.getPitch());
                    if (tick.get() != this.shotDelay) break;
                    tick.set(0);
                    Arrow arrow = (Arrow)turret.launchProjectile(Arrow.class, turret.getLocation().getDirection().multiply(2));
                    arrow.setRotation(neededRotation.getYaw(), neededRotation.getPitch());
                    arrow.setShooter((ProjectileSource)player);
                    arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                    arrow.setDamage((double)this.shotDamage);
                    arrow.setGravity(false);
                    break;
                }
            }, 20L, 1L);
            return;
        }
        player.sendMessage(Component.text((String)"You don't have any remaining turrets").color(TextColor.color((int)255, (int)0, (int)0)));
    }

    @Override
    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof ArmorStand && TURRETS.contains((ArmorStand)event.getEntity())) {
            event.setCancelled(true);
            event.getEntity().remove();
            block0: for (ArmorStand turret : Utils.cloneList(TURRETS)) {
                if (turret.getUniqueId() == event.getEntity().getUniqueId()) {
                    TURRETS.remove(turret);
                }
                for (String tag : turret.getScoreboardTags()) {
                    String name;
                    Player player;
                    if (!tag.startsWith("turret#") || (player = Bukkit.getPlayer((String)(name = tag.split("#")[1]))) == null) continue;
                    player.sendMessage(Component.text((String)"One of your turrets got destroyed").color(TextColor.color((int)0, (int)0, (int)255)));
                    continue block0;
                }
            }
        }
    }
}

