/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class RogueKit
extends AbstractKit {
    public static final RogueKit INSTANCE = new RogueKit();
    @FloatArg(min=0.0f)
    private final float cooldown;
    @IntArg
    private final int effectDuration;
    @DoubleArg
    private final double radius;

    private RogueKit() {
        super("Rogue", Material.GRAY_DYE);
        this.cooldown = 40.0f;
        this.radius = 10.0;
        this.effectDuration = 15;
        this.setMainKitItem(this.getDisplayMaterial());
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        int counter = 0;
        for (KitPlayer nearbyPlayerKitOwner : this.getKitPlayersInRadius(player, this.radius)) {
            Player nearbyPlayer = Bukkit.getPlayer((UUID)nearbyPlayerKitOwner.getUUID());
            if (nearbyPlayer == player) continue;
            ++counter;
            if (nearbyPlayerKitOwner.areKitsDisabled() || !nearbyPlayerKitOwner.isValid()) continue;
            nearbyPlayerKitOwner.disableKits(true);
            Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> nearbyPlayerKitOwner.disableKits(false), (long)this.effectDuration * 20L);
        }
        player.sendMessage("You disabled the kits of " + counter + " players");
        kitPlayer.activateKitCooldown(this);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

