/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ReviveKit
extends AbstractKit {
    public static final ReviveKit INSTANCE = new ReviveKit();
    private final String deathCounterKey = this.getName() + "counter";
    @FloatArg(min=0.0f)
    private final float cooldown;

    private ReviveKit() {
        super("Revive", Material.TOTEM_OF_UNDYING);
        this.cooldown = 60.0f;
        this.setMainKitItem(this.getDisplayMaterial());
        this.setUsesOffHand(true);
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        if (player != null && player.getInventory().getItemInOffHand().isSimilar(this.getMainKitItem())) {
            player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
        }
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        this.giveTotem(kitPlayer, player);
    }

    @Override
    @KitEvent
    public void onEntityResurrect(EntityResurrectEvent event) {
        Player player = (Player)event.getEntity();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        kitPlayer.putKitAttribute(this.deathCounterKey, kitPlayer.getKitAttributeOrDefault(this.deathCounterKey, 1) + 1);
        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> this.giveTotem(kitPlayer, player), (long)this.getCooldown() * 20L * (long)((Integer)kitPlayer.getKitAttribute(this.deathCounterKey)).intValue());
    }

    private void giveTotem(KitPlayer kitPlayer, Player player) {
        if (kitPlayer.isValid() && kitPlayer.hasKit(this)) {
            player.getInventory().setItemInOffHand(this.getMainKitItem());
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

