/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.mojang.datafixers.util.Pair;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.BetaKit;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.LongArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@BetaKit
public class RefillKit
extends AbstractKit {
    public static final RefillKit INSTANCE = new RefillKit();
    private static final String FORWARD_HEAD = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjgxMzYzM2JkNjAxNTJkOWRmNTRiM2Q5ZDU3M2E4YmMzNjU0OGI3MmRjMWEzMGZiNGNiOWVjMjU2ZDY4YWUifX19";
    @FloatArg
    private final float cooldown;
    @LongArg
    private final long refillTickSpeed;
    private final String refillTaskString;

    private RefillKit() {
        super("Refill", Material.MUSHROOM_STEW);
        this.setMainKitItem(new KitItemBuilder(Material.PLAYER_HEAD).setPlayerSkullSkin(FORWARD_HEAD).build());
        this.cooldown = 25.0f;
        this.refillTickSpeed = 1L;
        this.refillTaskString = "refillTask" + this.getName();
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        RefillTask refillTask = (RefillTask)((Object)kitPlayer.getKitAttribute(this.refillTaskString));
        if (refillTask != null) {
            refillTask.end();
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        this.autoRefill(event.getPlayer(), kitPlayer);
    }

    @Override
    @KitEvent
    public void onPlayerLeftClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        this.autoRefill(event.getPlayer(), kitPlayer);
    }

    private void autoRefill(Player player, KitPlayer kitPlayer) {
        PlayerInventory inventory = player.getInventory();
        Pair<Integer, ItemStack> soupsInInventory = this.getSoupOfInventory(inventory);
        if (soupsInInventory == null) {
            player.sendMessage(ChatColor.RED + "Keine Suppen mehr im Inventar");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        if (this.getFirstEmptySlot(inventory) == -1) {
            player.sendMessage(ChatColor.RED + "Du hast keine freie Hotbar");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        RefillTask refillTask = new RefillTask(player, kitPlayer);
        refillTask.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, this.refillTickSpeed);
        kitPlayer.putKitAttribute(this.refillTaskString, refillTask);
    }

    private Integer getFirstEmptySlot(PlayerInventory inventory) {
        List<Material> emptyItems = Arrays.asList(Material.AIR, Material.BOWL);
        for (int i = 0; i < 9; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item != null && !emptyItems.contains(item.getType())) continue;
            return i;
        }
        return -1;
    }

    private Pair<Integer, ItemStack> getSoupOfInventory(PlayerInventory inventory) {
        for (int i = 9; i <= 35; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || !item.getType().equals((Object)Material.MUSHROOM_STEW)) continue;
            return Pair.of((Object)i, (Object)item);
        }
        return null;
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    private class RefillTask
    extends BukkitRunnable {
        private final Player player;
        private final KitPlayer kitPlayer;
        private boolean cooldownFlag;

        private RefillTask(Player player, KitPlayer kitPlayer) {
            this.player = player;
            this.kitPlayer = kitPlayer;
        }

        public void run() {
            Integer emptySlot;
            if (!this.kitPlayer.isValid() || this.isCancelled()) {
                this.end();
                return;
            }
            PlayerInventory inventory = this.player.getInventory();
            Pair<Integer, ItemStack> soupPair = RefillKit.this.getSoupOfInventory(inventory);
            if (soupPair == null) {
                this.player.sendMessage(ChatColor.RED + "Keine Suppen mehr im Inventar");
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                this.end();
                return;
            }
            if (!this.cooldownFlag) {
                this.kitPlayer.activateKitCooldown(INSTANCE);
                this.cooldownFlag = true;
            }
            if ((emptySlot = RefillKit.this.getFirstEmptySlot(inventory)) != -1) {
                inventory.setItem(emptySlot.intValue(), (ItemStack)soupPair.getSecond());
                inventory.setItem(((Integer)soupPair.getFirst()).intValue(), new ItemStack(Material.AIR));
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            } else {
                this.end();
            }
        }

        private void end() {
            this.kitPlayer.putKitAttribute(RefillKit.this.refillTaskString, null);
            this.cancel();
        }
    }
}

