/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.kits.BeequeenKit;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ChanceUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ReaperKit
extends AbstractKit
implements Listener {
    public static final ReaperKit INSTANCE = new ReaperKit();
    @IntArg
    private final int maxUses;
    @IntArg
    private final int likelihood;
    @IntArg
    private final int blueWitherLikelihood;
    @IntArg
    private final int witherDuration;
    @IntArg
    private final int witherAmplifier;
    @FloatArg(min=0.0f)
    private final float cooldown;
    private final String isReaperSkullKey = this.getName() + "isReaperSkull";

    private ReaperKit() {
        super("Reaper", Material.WITHER_SKELETON_SKULL);
        this.cooldown = 15.0f;
        this.maxUses = 2;
        this.likelihood = 100;
        this.blueWitherLikelihood = 5;
        this.witherAmplifier = 1;
        this.witherDuration = 3;
        this.setMainKitItem(new ItemBuilder(Material.STONE_HOE).setEnchantment(Enchantment.VANISHING_CURSE, 1).setUnbreakable(true).build());
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntity().hasMetadata(this.isReaperSkullKey)) {
            event.blockList().removeIf(block -> block.hasMetadata(BeequeenKit.INSTANCE.getIsHoneyBlockKey()));
        }
    }

    @Override
    @KitEvent
    public void onHitLivingEntityWithKitItem(EntityDamageByEntityEvent event, KitPlayer attacker, LivingEntity entity) {
        if (ChanceUtils.roll((int)this.likelihood)) {
            entity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, this.witherDuration * 20, this.witherAmplifier));
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        WitherSkull witherSkull = (WitherSkull)player.getWorld().spawn(player.getLocation().clone().add(0.0, 1.0, 0.0), WitherSkull.class);
        witherSkull.setMetadata(this.isReaperSkullKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)this.isReaperSkullKey));
        if (ChanceUtils.roll((int)this.blueWitherLikelihood)) {
            witherSkull.setCharged(true);
        }
        witherSkull.setVelocity(player.getLocation().getDirection().multiply(1.5));
        KitApi.getInstance().checkUsesForCooldown(player, (AbstractKit)this, this.maxUses);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }

    public String getIsReaperSkullKey() {
        return this.isReaperSkullKey;
    }
}

