/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import de.hglabor.utils.noriskutils.ItemBuilder;
import java.util.Locale;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PoseidonKit
extends AbstractKit {
    public static final PoseidonKit INSTANCE = new PoseidonKit();
    @IntArg(min=0)
    private final int rainTime;
    @IntArg
    private final int speedAmplifier;
    @IntArg
    private final int regenerationAmplifier;
    private final String rainRunnable = this.getName() + "rainRunnable";

    private PoseidonKit() {
        super("Poseidon", new ItemBuilder(Material.TRIDENT).setEnchantment(Enchantment.RIPTIDE, 3).setName("Poseidon").build());
        this.rainTime = 25;
        this.speedAmplifier = 0;
        this.regenerationAmplifier = 0;
        this.setKitItemPlaceable(true);
        this.setMainKitItem(this.createPoseidonKitItem());
    }

    private ItemStack createPoseidonKitItem() {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.TRIDENT));
        NBTTagList modifiers = new NBTTagList();
        NBTTagCompound compound = new NBTTagCompound();
        compound.set("AttributeName", (NBTBase)NBTTagString.a((String)"generic.attackDamage"));
        compound.set("Name", (NBTBase)NBTTagString.a((String)"generic.attackDamage"));
        compound.set("Amount", (NBTBase)NBTTagInt.a((int)2));
        compound.set("Operation", (NBTBase)NBTTagInt.a((int)0));
        compound.set("UUIDLeast", (NBTBase)NBTTagInt.a((int)894654));
        compound.set("UUIDMost", (NBTBase)NBTTagInt.a((int)2872));
        compound.set("Slot", (NBTBase)NBTTagString.a((String)"mainhand"));
        modifiers.add((Object)compound);
        compound.set("AttributeModifiers", (NBTBase)modifiers);
        itemStack.setTag(compound);
        return new ItemBuilder(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack).clone()).setUnbreakable(true).setEnchantment(Enchantment.RIPTIDE, 3).setName("Poseidon").build();
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        if (kitPlayer.getKitAttribute(this.rainRunnable) != null) {
            ((PoseidonRain)((Object)kitPlayer.getKitAttribute(this.rainRunnable))).stop();
        }
    }

    @Override
    @KitEvent(clazz=PlayerDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer victim) {
        killer.getBukkitPlayer().ifPresent(player -> {
            if (killer.getKitAttribute(this.rainRunnable) != null) {
                ((PoseidonRain)((Object)((Object)killer.getKitAttribute(this.rainRunnable)))).addTime(this.rainTime);
            } else {
                PoseidonRain poseidonRain = new PoseidonRain((Player)player);
                killer.putKitAttribute(this.rainRunnable, poseidonRain);
                poseidonRain.runTaskTimer((Plugin)KitApi.getInstance().getPlugin(), 0L, 20L);
            }
        });
    }

    private final class PoseidonRain
    extends BukkitRunnable {
        private final Player player;
        private final BossBar rainBar;
        private long endTime;
        private int timer;

        private PoseidonRain(Player player) {
            this.rainBar = Bukkit.createBossBar((String)Localization.t((String)"poseidon.rain", (Locale)ChatUtils.locale((Player)player)), (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            this.player = player;
            this.endTime = PoseidonKit.this.rainTime;
            this.startRain();
        }

        private void startRain() {
            PacketPlayOutGameStateChange rainPacket = new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f);
            ((CraftPlayer)this.player).getHandle().b.sendPacket((Packet)rainPacket);
            this.rainBar.addPlayer(this.player);
        }

        public void run() {
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 40, PoseidonKit.this.speedAmplifier));
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, PoseidonKit.this.regenerationAmplifier));
            double progress = (double)this.timer / (double)this.endTime;
            this.rainBar.setProgress(Math.min(progress, 1.0));
            if ((long)this.timer > this.endTime) {
                this.stop();
            }
            ++this.timer;
        }

        public void stop() {
            this.cancel();
            PacketPlayOutGameStateChange rainPacket = new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f);
            ((CraftPlayer)this.player).getHandle().b.sendPacket((Packet)rainPacket);
            this.rainBar.removeAll();
            KitApi.getInstance().getPlayer(this.player).putKitAttribute(PoseidonKit.this.rainRunnable, null);
        }

        public void addTime(int time) {
            this.endTime += (long)time;
        }
    }
}

