/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.MultipleKitItemsKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.items.KitItemAction;
import de.hglabor.plugins.kitapi.kit.items.KitItemBuilder;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PirateKit
extends MultipleKitItemsKit
implements Listener {
    public static final PirateKit INSTANCE = new PirateKit();
    @IntArg
    private final int explosionBarrelsLimit;
    @IntArg
    private final int fireballSpeed;
    @FloatArg(min=0.1f, max=100.0f)
    private final float explosionPower;
    @FloatArg(min=0.1f, max=100.0f)
    private final float additionalExplosionPowerStep;
    @FloatArg(min=0.1f, max=100.0f)
    private final float maxAdditionalExplosionPower;
    private final String explosionBarrelMetaKey;
    private final String explosionBarrelsKey;
    private final String UUID_KEY = "uuid";
    private final ItemStack canon = new KitItemBuilder(Material.FIRE_CHARGE).setName("Kanone").setDescription("Abschuss!!").build();
    private final ItemStack remoteDetonator = new KitItemBuilder(Material.TRIPWIRE_HOOK).setName("Fernz\u00fcnder").setDescription("Explosion!!").build();

    protected PirateKit() {
        super("Pirate", Material.FIRE_CHARGE);
        Map<KitItemAction, Float> kitActions = Map.of(new KitItemAction(this.canon, "pirate.canon"), Float.valueOf(5.0f), new KitItemAction(this.remoteDetonator, "pirate.remoteDetonator"), Float.valueOf(5.0f));
        this.setItemsAndCooldown(kitActions);
        this.explosionBarrelsLimit = 3;
        this.explosionPower = 5.0f;
        this.fireballSpeed = 2;
        this.explosionBarrelMetaKey = this.getName() + "explosionBarrel";
        this.explosionBarrelsKey = this.getName() + "explosionBarrelsList";
        this.maxAdditionalExplosionPower = 5.0f;
        this.additionalExplosionPowerStep = 0.5f;
    }

    @Override
    @KitEvent
    public void onPlayerLeftClicksOneOfMultipleKitItems(PlayerInteractEvent event, KitPlayer kitPlayer, ItemStack item) {
    }

    @Override
    @KitEvent
    public void onPlayerRightClicksOneOfMultipleKitItems(PlayerInteractEvent event, KitPlayer kitPlayer, ItemStack item) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (item.isSimilar(this.remoteDetonator)) {
            List barrels = kitPlayer.getKitAttributeOrDefault(this.explosionBarrelsKey, Collections.emptyList());
            for (Block barrel : barrels) {
                if (!barrel.hasMetadata(this.explosionBarrelMetaKey)) continue;
                barrel.removeMetadata(this.explosionBarrelMetaKey, (Plugin)KitApi.getInstance().getPlugin());
                barrel.removeMetadata("uuid", (Plugin)KitApi.getInstance().getPlugin());
                world.createExplosion(barrel.getLocation(), this.explosionPower);
            }
            barrels.clear();
        } else if (item.isSimilar(this.canon)) {
            player.launchProjectile(Fireball.class, player.getEyeLocation().getDirection().multiply(this.fireballSpeed));
            this.activateCooldown(kitPlayer, item);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block barrel = event.getBlockPlaced();
        if (!barrel.getType().equals((Object)Material.BARREL)) {
            return;
        }
        Player player = event.getPlayer();
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        if (kitPlayer.hasKit(this)) {
            List barrels = kitPlayer.getKitAttributeOrDefault(this.explosionBarrelsKey, new ArrayList());
            barrel.setMetadata(this.explosionBarrelMetaKey, (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            barrel.setMetadata("uuid", (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)player.getUniqueId()));
            barrels.add(barrel);
            kitPlayer.putKitAttribute(this.explosionBarrelsKey, barrels);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.hasMetadata(this.explosionBarrelMetaKey) && block.hasMetadata("uuid")) {
            UUID owner = (UUID)((MetadataValue)block.getMetadata("uuid").get(0)).value();
            if (owner == null) {
                return;
            }
            Optional<Player> optionalPlayer = Optional.ofNullable(Bukkit.getPlayer((UUID)owner));
            optionalPlayer.ifPresent(player -> {
                String key = "pirat.destroyed";
                Locale locale = ChatUtils.locale((UUID)owner);
                ImmutableMap arguments = ImmutableMap.of((Object)"location", (Object)block.getLocation().toString());
                player.sendMessage(Localization.t((String)key, (Map)arguments, (Locale)locale));
                KitPlayer kitPlayer = KitApi.getInstance().getPlayer((Player)player);
                List barrels = kitPlayer.getKitAttributeOrDefault(this.explosionBarrelsKey, Collections.emptyList());
                barrels.removeIf(barrel -> {
                    if (barrel.equals(block)) {
                        barrel.removeMetadata(this.explosionBarrelMetaKey, (Plugin)KitApi.getInstance().getPlugin());
                        barrel.removeMetadata("uuid", (Plugin)KitApi.getInstance().getPlugin());
                        return true;
                    }
                    return false;
                });
            });
        }
    }

    private float getAdditionalExplosionPower(Block block) {
        AtomicInteger amount = new AtomicInteger();
        Arrays.stream(((Barrel)block).getInventory().getStorageContents()).filter(itemStack -> itemStack.getType() == Material.GUNPOWDER).collect(Collectors.toList()).forEach(itemStack -> amount.addAndGet(itemStack.getAmount()));
        return (float)amount.get() * this.additionalExplosionPowerStep;
    }
}

