/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.WorldEditUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MedusaKit
extends AbstractKit {
    public static final MedusaKit INSTANCE = new MedusaKit();
    @FloatArg
    private final float cooldown;
    @DoubleArg(min=1.0, max=100.0)
    private final double radius;

    private MedusaKit() {
        super("Medusa", Material.ZOMBIE_HEAD);
        this.setMainKitItem(this.getDisplayMaterial());
        this.cooldown = 30.0f;
        this.radius = 30.0;
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        for (LivingEntity nearby : player.getWorld().getNearbyLivingEntities(player.getLocation(), this.radius)) {
            KitPlayer nearbyKitPlayer;
            if (!(nearby instanceof Player) || !(nearbyKitPlayer = KitApi.getInstance().getPlayer((Player)nearby)).isValid() || nearby.getUniqueId() == player.getUniqueId() || nearby.getTargetEntity(30) == null || nearby.getTargetEntity(30).getUniqueId() != player.getUniqueId()) continue;
            WorldEditUtils.createCylinder((World)nearby.getWorld(), (Location)nearby.getLocation(), (int)1, (boolean)true, (int)2, (Material)Material.COBBLESTONE);
            nearby.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, false, false));
            nearby.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 10, false, false));
        }
        kitPlayer.activateKitCooldown(this);
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

