/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.collect.ImmutableMap;
import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.config.KitMetaData;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.plugins.kitapi.util.pathfinder.LaborPathfinderFindTarget;
import de.hglabor.plugins.kitapi.util.pathfinder.LaborPathfinderGhastAttack;
import de.hglabor.plugins.kitapi.util.pathfinder.LaborPathfinderGoalBlazeFireball;
import de.hglabor.plugins.kitapi.util.pathfinder.LaborPathfinderGoalGhastIdleMove;
import de.hglabor.plugins.kitapi.util.pathfinder.LaborPathfinderMoveToPlayer;
import de.hglabor.utils.localization.Localization;
import de.hglabor.utils.noriskutils.ChatUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ManipulationKit
extends AbstractKit
implements Listener {
    public static final ManipulationKit INSTANCE = new ManipulationKit();
    @IntArg
    private final int maxManipulatedMobs;
    private final String collectedMobsKey;

    public ManipulationKit() {
        super("Manipulation", Material.IRON_NUGGET);
        this.setMainKitItem(this.getDisplayMaterial());
        this.collectedMobsKey = this.getName() + "collectedMobs";
        this.maxManipulatedMobs = 4;
    }

    @Override
    public void onEnable(KitPlayer kitPlayer) {
        kitPlayer.putKitAttribute(this.collectedMobsKey, new HashSet());
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        Set controlledMobs = (Set)kitPlayer.getKitAttribute(this.collectedMobsKey);
        if (controlledMobs == null) {
            return;
        }
        for (UUID controlledMob : controlledMobs) {
            Entity entity = Bukkit.getEntity((UUID)controlledMob);
            if (entity == null) continue;
            entity.remove();
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickLivingEntityWithKitItem(PlayerInteractAtEntityEvent event, KitPlayer kitPlayer, LivingEntity entity) {
        Player player = event.getPlayer();
        if (entity instanceof Mob) {
            Mob mob = (Mob)event.getRightClicked();
            EntityInsentient craftMonster = (EntityInsentient)((CraftEntity)mob).getHandle();
            if (this.isManipulatedMob(mob)) {
                Player manipulator = this.getManipulator(mob);
                if (manipulator != null && manipulator.getUniqueId().equals(player.getUniqueId())) {
                    player.sendMessage(Localization.t((String)"manipulator.alreadyYourMob", (Locale)ChatUtils.locale((Player)player)));
                    return;
                }
                player.sendMessage(Localization.t((String)"manipulator.alreadyControlled", (Locale)ChatUtils.locale((Player)player)));
                return;
            }
            if (this.getManipulatedMobAmount(player) >= this.maxManipulatedMobs) {
                player.sendMessage(Localization.t((String)"manipulator.maxAmount", (Locale)ChatUtils.locale((Player)player)));
                return;
            }
            mob.setMetadata(KitMetaData.MANIPULATED_MOB.getKey(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            mob.setMetadata(player.getUniqueId().toString(), (MetadataValue)new FixedMetadataValue((Plugin)KitApi.getInstance().getPlugin(), (Object)""));
            this.addMob(player, (Entity)mob);
            boolean attack = mob.getType() != EntityType.CREEPER && mob.getType() != EntityType.SKELETON;
            this.clearPathfinders(craftMonster);
            mob.setTarget(null);
            craftMonster.bP.a(0, (PathfinderGoal)new LaborPathfinderMoveToPlayer((EntityHuman)((CraftPlayer)player).getHandle(), craftMonster));
            craftMonster.bP.a(1, (PathfinderGoal)new PathfinderGoalFloat(craftMonster));
            craftMonster.bQ.a(0, (PathfinderGoal)new LaborPathfinderFindTarget(craftMonster, player.getUniqueId(), attack));
            switch (mob.getType()) {
                case HUSK: 
                case ZOMBIE: 
                case ENDERMAN: {
                    craftMonster.bP.a(3, (PathfinderGoal)new PathfinderGoalMeleeAttack((EntityCreature)craftMonster, 0.3, false));
                    break;
                }
                case SKELETON: {
                    craftMonster.bP.a(3, (PathfinderGoal)new PathfinderGoalBowShoot((EntityMonster)((EntitySkeletonAbstract)craftMonster), 1.0, 20, 15.0f));
                    break;
                }
                case CREEPER: {
                    ((Creeper)mob).setPowered(false);
                    ((Creeper)mob).setIgnited(false);
                    craftMonster.bP.a(3, (PathfinderGoal)new PathfinderGoalSwell((EntityCreeper)craftMonster));
                    break;
                }
                case BLAZE: {
                    craftMonster.bP.a(3, (PathfinderGoal)new LaborPathfinderGoalBlazeFireball((EntityBlaze)craftMonster));
                    break;
                }
                case GHAST: {
                    craftMonster.bP.a(3, (PathfinderGoal)new LaborPathfinderGhastAttack((EntityGhast)craftMonster));
                    craftMonster.bP.a(4, (PathfinderGoal)new LaborPathfinderGoalGhastIdleMove((EntityGhast)craftMonster));
                    break;
                }
            }
            player.getWorld().spawnParticle(Particle.HEART, mob.getEyeLocation(), 1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 10.0f, 10.0f);
        }
    }

    @EventHandler
    public void onEntityDespawn(EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (this.isManipulatedMob(mob)) {
            Player manipulator;
            this.removeMob(mob);
            if (this.getManipulator(mob) == null && (manipulator = this.getManipulator(mob)) != null) {
                manipulator.sendMessage(Localization.INSTANCE.getMessage("manipulator.mobLoose", (Map)ImmutableMap.of((Object)"amount", (Object)String.valueOf(this.getManipulatedMobAmount(manipulator))), ChatUtils.locale((Player)manipulator)));
            }
        }
    }

    private void addMob(Player player, Entity mob) {
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        Set controlledMobs = (Set)kitPlayer.getKitAttribute(this.collectedMobsKey);
        controlledMobs.add(mob.getUniqueId());
    }

    private void removeMob(Mob mob) {
        Player player = this.getManipulator(mob);
        if (player != null) {
            KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
            Set controlledMobs = (Set)kitPlayer.getKitAttribute(this.collectedMobsKey);
            controlledMobs.remove(mob.getUniqueId());
        }
    }

    private int getManipulatedMobAmount(Player player) {
        KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
        Set controlledMobs = (Set)kitPlayer.getKitAttribute(this.collectedMobsKey);
        return controlledMobs.size();
    }

    private boolean isManipulatedMob(Mob entity) {
        return entity.hasMetadata(KitMetaData.MANIPULATED_MOB.getKey());
    }

    private Player getManipulator(Mob entity) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            KitPlayer kitPlayer = KitApi.getInstance().getPlayer(player);
            if (!kitPlayer.isValid() || !entity.hasMetadata(kitPlayer.getUUID().toString())) continue;
            return player;
        }
        return null;
    }

    public void clearPathfinders(EntityInsentient entity) {
        entity.bP = new PathfinderGoalSelector(entity.t.getMethodProfilerSupplier());
        entity.bQ = new PathfinderGoalSelector(entity.t.getMethodProfilerSupplier());
    }
}

