/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.BoolArg;
import de.hglabor.plugins.kitapi.kit.settings.DoubleArg;
import de.hglabor.plugins.kitapi.kit.settings.FloatArg;
import de.hglabor.plugins.kitapi.kit.settings.IntArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import de.hglabor.utils.noriskutils.ChanceUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class MagmaKit
extends AbstractKit {
    public static final MagmaKit INSTANCE = new MagmaKit();
    @IntArg
    private final int likelihood;
    @IntArg
    private final int effectDuration;
    @IntArg
    private final int extraDamage;
    @DoubleArg(min=1.0, max=100.0)
    private final double radius;
    @IntArg(min=1, max=16)
    private final int height;
    @DoubleArg(min=0.1, max=1.0)
    private final double velocity;
    @BoolArg
    private final boolean enableVelocity;
    @FloatArg
    private final float cooldown;

    private MagmaKit() {
        super("Magma", Material.MAGMA_BLOCK);
        this.setMainKitItem(this.getDisplayMaterial());
        this.likelihood = 33;
        this.effectDuration = 2;
        this.radius = 5.0;
        this.height = 8;
        this.velocity = 0.5;
        this.extraDamage = 2;
        this.cooldown = 45.0f;
        this.enableVelocity = true;
    }

    @Override
    @KitEvent(ignoreCooldown=true)
    public void onPlayerAttacksLivingEntity(EntityDamageByEntityEvent event, KitPlayer attacker, LivingEntity entity) {
        if (ChanceUtils.roll((int)this.likelihood)) {
            entity.setFireTicks(this.effectDuration * 20);
        }
    }

    @Override
    @KitEvent
    public void onPlayerRightClickKitItem(PlayerInteractEvent event, KitPlayer kitPlayer) {
        Player player = event.getPlayer();
        this.playFireCircle(player);
        for (LivingEntity nearby : player.getWorld().getNearbyLivingEntities(player.getLocation(), this.radius)) {
            KitPlayer nearbyKitPlayer;
            if (nearby instanceof Player && !(nearbyKitPlayer = KitApi.getInstance().getPlayer((Player)nearby)).isValid() || nearby.getUniqueId() == player.getUniqueId()) continue;
            this.setEntityOnFire((Entity)player, nearby);
        }
        kitPlayer.activateKitCooldown(this);
    }

    private void playFireCircle(Player player) {
        Location loc = player.getLocation();
        World world = player.getWorld();
        int i = 0;
        while ((double)i <= this.radius) {
            world.spawnParticle(Particle.FLAME, loc.clone().add((double)i, 0.0, 0.0), 0, 0.0, 0.0, 0.0, 8.0);
            world.spawnParticle(Particle.FLAME, loc.clone().add((double)(i * -1), 0.0, 0.0), 0, 0.0, 0.0, 0.0, 8.0);
            world.spawnParticle(Particle.FLAME, loc.clone().add(0.0, 0.0, (double)i), 0, 0.0, 0.0, 0.0, 8.0);
            world.spawnParticle(Particle.FLAME, loc.clone().add(0.0, 0.0, (double)(i * -1)), 0, 0.0, 0.0, 0.0, 8.0);
            ++i;
        }
        for (double i2 = 0.0; i2 < (double)this.height; i2 += 1.0) {
            for (double y = 0.0; y < Math.PI * 2; y += 0.1) {
                double x = this.radius * Math.cos(y);
                double z = this.radius * Math.sin(y);
                loc.getWorld().spawnParticle(Particle.FLAME, loc.clone().add(x, i2 / 4.0, z), 0, 0.0, 0.0, 0.0, 5.0);
            }
        }
    }

    private void setEntityOnFire(Entity attacker, LivingEntity target) {
        target.setFireTicks(this.effectDuration * 20);
        if (this.enableVelocity) {
            target.setVelocity(new Vector(0.0, this.velocity, 0.0));
        }
        if (ChanceUtils.roll((int)this.likelihood)) {
            target.damage((double)this.extraDamage, attacker);
        }
    }

    @Override
    public float getCooldown() {
        return this.cooldown;
    }
}

