/*
 * Decompiled with CFR 0.152.
 */
package de.hglabor.plugins.kitapi.kit.kits;

import de.hglabor.plugins.kitapi.KitApi;
import de.hglabor.plugins.kitapi.kit.AbstractKit;
import de.hglabor.plugins.kitapi.kit.events.KitEvent;
import de.hglabor.plugins.kitapi.kit.settings.LongArg;
import de.hglabor.plugins.kitapi.player.KitPlayer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class LifestealerKit
extends AbstractKit
implements Listener {
    public static final LifestealerKit INSTANCE = new LifestealerKit();
    @LongArg
    private final long time;

    private LifestealerKit() {
        super("Lifestealer", Material.RED_DYE);
        this.time = 30L;
    }

    @Override
    @KitEvent(clazz=PlayerDeathEvent.class)
    public void onPlayerKillsPlayer(KitPlayer killer, KitPlayer dead) {
        Player player = Bukkit.getPlayer((UUID)killer.getUUID());
        Player killed = Bukkit.getPlayer((UUID)dead.getUUID());
        double previousHearts = player.getMaxHealth();
        player.setMaxHealth(previousHearts + killed.getMaxHealth());
        player.setHealth(player.getMaxHealth());
        Bukkit.getScheduler().runTaskLater((Plugin)KitApi.getInstance().getPlugin(), () -> player.setMaxHealth(previousHearts), this.time * 20L);
    }

    @Override
    public void onDeactivation(KitPlayer kitPlayer) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        player.setMaxHealth(20.0);
    }

    @Override
    public void onDisable(KitPlayer kitPlayer) {
        Player player = Bukkit.getPlayer((UUID)kitPlayer.getUUID());
        player.setMaxHealth(20.0);
    }

    @Override
    @KitEvent(clazz=EntityDamageByEntityEvent.class)
    public void onPlayerGetsAttackedByLivingEntity(EntityDamageByEntityEvent event, Player player, LivingEntity attacker) {
        double health = player.getMaxHealth() - event.getDamage();
        if (health <= 20.0) {
            player.setMaxHealth(20.0);
        } else {
            player.setMaxHealth(health);
        }
    }
}

